/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.tree.helpers.lists;

import org.eclipse.swt.graphics.Image;

import alma.acs.tmcdb.AlarmDefinition;
import alma.acs.tmcdb.Configuration;
import alma.obops.tmcdb.alarms.ui.tree.helpers.AlarmDefinitionHelper;
import alma.obops.tmcdb.alarms.ui.tree.helpers.ListHelper;
import alma.obops.tmcdb.alarms.ui.tree.typedlists.AlarmDefinitionList;
import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;

public class AlarmDefinitionListHelper extends ListHelper
{
	@SuppressWarnings("unused")
	private Configuration configuration;
	
	public AlarmDefinitionListHelper(AlarmDefinitionList list, Configuration configuration) {
		super(list);
		this.configuration = configuration;
	}

	@Override
	public Image getFirstColumnImage() {
		return RcpUtils.getImage("icons/reductionlink.png");
	}
	
	@Override 
	public String getFirstColumnText()
	{
		return "Reduction links";
	}
	
	@Override
	public Object[] getChildren()
	{
		Object[] children = super.getChildren();
		Object[] retAlarmDefs = new AlarmDefinition[children.length];
		int count = 0;
		for(Object obj : children) {
			AlarmDefinition def = (AlarmDefinition) obj;
			def = AlarmDefinitionHelper.findAlarmDefinition(def);
			retAlarmDefs[count++] = def;
		}
		
		return retAlarmDefs;
	}
}
