/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.tree.helpers.factory;

import alma.acs.tmcdb.AlarmCategory;
import alma.acs.tmcdb.AlarmDefinition;
import alma.acs.tmcdb.Configuration;
import alma.acs.tmcdb.DefaultMember;
import alma.acs.tmcdb.FaultCode;
import alma.acs.tmcdb.FaultFamily;
import alma.acs.tmcdb.FaultMember;
import alma.acs.tmcdb.ReductionLink;
import alma.acs.tmcdb.ReductionThreshold;
import alma.obops.tmcdb.alarms.ui.tree.helpers.AlarmCategoryHelper;
import alma.obops.tmcdb.alarms.ui.tree.helpers.AlarmDefinitionHelper;
import alma.obops.tmcdb.alarms.ui.tree.helpers.ConfigurationHelper;
import alma.obops.tmcdb.alarms.ui.tree.helpers.DefaultMemberHelper;
import alma.obops.tmcdb.alarms.ui.tree.helpers.FaultCodeHelper;
import alma.obops.tmcdb.alarms.ui.tree.helpers.FaultFamilyHelper;
import alma.obops.tmcdb.alarms.ui.tree.helpers.FaultMemberHelper;
import alma.obops.tmcdb.alarms.ui.tree.helpers.ReductionLinkHelper;
import alma.obops.tmcdb.alarms.ui.tree.helpers.ReductionThresholdHelper;
import alma.obops.tmcdb.alarms.ui.tree.helpers.ThreeColumnDomainObjectHelper;
import alma.obops.tmcdb.alarms.ui.tree.helpers.lists.AlarmCategoryListHelper;
import alma.obops.tmcdb.alarms.ui.tree.helpers.lists.AlarmDefinitionListHelper;
import alma.obops.tmcdb.alarms.ui.tree.helpers.lists.DefaultMemberListHelper;
import alma.obops.tmcdb.alarms.ui.tree.helpers.lists.FaultCodeListHelper;
import alma.obops.tmcdb.alarms.ui.tree.helpers.lists.FaultFamilyListHelper;
import alma.obops.tmcdb.alarms.ui.tree.helpers.lists.FaultMemberListHelper;
import alma.obops.tmcdb.alarms.ui.tree.typedlists.AlarmCategoryList;
import alma.obops.tmcdb.alarms.ui.tree.typedlists.AlarmDefinitionList;
import alma.obops.tmcdb.alarms.ui.tree.typedlists.DefaultMemberList;
import alma.obops.tmcdb.alarms.ui.tree.typedlists.FaultCodeList;
import alma.obops.tmcdb.alarms.ui.tree.typedlists.FaultFamilyList;
import alma.obops.tmcdb.alarms.ui.tree.typedlists.FaultMemberList;
import alma.tmcdb.domain.HwConfiguration;

public class AlarmHelperFactory implements ThreeColumnDomainObjectHelperFactory 
{
	private Configuration configuration;
	
	@Override
	public ThreeColumnDomainObjectHelper getHelper(Object object) 
	{
		ThreeColumnDomainObjectHelper retVal = null;
		
		if(object instanceof AlarmDefinition) 
		{
			retVal = new AlarmDefinitionHelper((AlarmDefinition) object, configuration);
		} 
		else if(object instanceof AlarmDefinitionList) {
			retVal = new AlarmDefinitionListHelper((AlarmDefinitionList) object, configuration);
		}
		else if(object instanceof AlarmCategory) {
			retVal = new AlarmCategoryHelper((AlarmCategory) object, configuration);
		}
		else if(object instanceof AlarmCategoryList) {
			retVal = new AlarmCategoryListHelper((AlarmCategoryList) object, configuration);
		}
//		else if(object instanceof ReductionLinkList) {
//			retVal = new ReductionLinkListHelper((ReductionLinkList) object, configuration, RcpUtils.getWindowConfigurer().getWindow().getShell());
//		}
		else if(object instanceof DefaultMember) {
			retVal = new DefaultMemberHelper((DefaultMember) object, configuration);
		}
		else if(object instanceof DefaultMemberList) {
			retVal = new DefaultMemberListHelper((DefaultMemberList) object, configuration);
		}
		else if(object instanceof FaultCode) {
			retVal = new FaultCodeHelper((FaultCode) object, configuration);
		}
		else if(object instanceof FaultCodeList) {
			retVal = new FaultCodeListHelper((FaultCodeList) object, configuration);
		}
		else if(object instanceof FaultFamily) {
			retVal = new FaultFamilyHelper((FaultFamily) object, configuration);
		}
		else if(object instanceof FaultFamilyList) {
			retVal = new FaultFamilyListHelper((FaultFamilyList) object, configuration);
		}
		else if(object instanceof FaultMember) {
			retVal = new FaultMemberHelper((FaultMember) object, configuration);
		}
		else if(object instanceof FaultMemberList) {
			retVal = new FaultMemberListHelper((FaultMemberList) object, configuration);
		} 
		else if(object instanceof HwConfiguration) {
			retVal = new ConfigurationHelper(((HwConfiguration) object).getSwConfiguration());
		} 
		else if(object instanceof ReductionLink) 
		{
			ReductionLinkHelper helper = new ReductionLinkHelper((ReductionLink) object, configuration);
			retVal = helper;
		}
		else if(object instanceof ReductionThreshold) {
			retVal = new ReductionThresholdHelper((ReductionThreshold) object);
		}
		
		return retVal;
	}

	public void setConfiguration(Configuration conf) {
		this.configuration = conf;
	}
}
