/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.tree.helpers;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

/**
 * Interface for helper objects related to underlying
 * "real world" domain objects. This allows helpers to 
 * provide additional UI-specific information related to 
 * the domain objects, while keeping the domain objects
 * "unpolluted" with UI concepts.
 * 
 * @author sharrington
 */
public interface ThreeColumnDomainObjectHelper 
{
	/**
	 * Getter for the first column image used in tree views.
	 * @return the image, if any, to use in the first column of a tree view.
	 */
	public Image getFirstColumnImage();
	
	/**
	 * Getter for the second column image used in tree views.
	 * @return the image, if any, to use in the second column of a tree view.
	 */
	public Image getSecondColumnImage();
	
	/**
	 * Getter for the third column image used in tree views.
	 * @return the image, if any, to use in the third column of a tree view.
	 */
	public Image getThirdColumnImage();
	
	/**
	 * Getter for the first column text used in tree views.
	 * @return the text, if any, to use in the first column of a tree view.
	 */
	public String getFirstColumnText();
	
	/**
	 * Getter for the second column text used in tree views.
	 * @return the text, if any, to use in the second column of a tree view.
	 */
	public String getSecondColumnText();
	
	/**
	 * Getter for the third column text used in tree views.
	 * @return the text, if any, to use in the third column of a tree view.
	 */
	public String getThirdColumnText();
	
	/**
	 * Getter for boolean which indicates if the object has any children
	 * with respect to how it is displayed in the tree view.
	 * 
	 * @return boolean indicating if the object has children (true) or not (false), 
	 * i.e. whether the tree view should show an icon for expanding the 
	 * domain object / tree node (true) or not (false) in the tree.
	 */
	public boolean hasChildren();
	
	/**
	 * Getter for the children, if any, of an object, for use in the tree
	 * view when expanding/contracting nodes.
	 * 
	 * @return an array of objects representing the children, if any,
	 * of the domain object (tree node).
	 */
	public Object[] getChildren();

	/**
	 * Getter for the font to be used to display this object's main label
	 * @return The font to be used to display this object's main label
	 */
	public Font getFont();

	/**
	 * Getter for the foreground color to display this object's main label
	 * @return
	 */
	public Color getForeground();
}
