/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.tree.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

import alma.acs.tmcdb.ReductionLink;
import alma.acs.tmcdb.ReductionLinkType;
import alma.acs.tmcdb.ReductionThreshold;
import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.utils.conversation.AlarmConversationUtils;

public class ReductionThresholdHelper implements ThreeColumnDomainObjectHelper  
{
	private ReductionThreshold reductionThreshold;
	private static Map<Integer, ReductionThreshold> reductionThresholdsMap = new HashMap<Integer, ReductionThreshold>();
	
	public ReductionThresholdHelper(ReductionThreshold threshold) 
	{
		this.reductionThreshold = ReductionThresholdHelper.findReductionThreshold(threshold);
	}
	
	@Override
	public Object[] getChildren() 
	{
		Object[] retVal = null;
		List<ReductionLink> children = new ArrayList<ReductionLink>();
		
		Set<ReductionLink> parentLinksOfAlarmDefinition = reductionThreshold.getAlarmDefinition().getReductionLinksForParentalarmdefid();
		for(ReductionLink link : parentLinksOfAlarmDefinition)
		{
			if(link.getType().equals(ReductionLinkType.MULTIPLICITY)) 
			{
				children.add(link);
			}
		}
		if(children.size() > 0)
		{
			retVal = children.toArray(new Object[children.size()]);
		}
		return retVal;
	}

	@Override
	public Image getFirstColumnImage() {
		return RcpUtils.getImage("icons/reduction-threshold.png");
	}

	@Override
	public String getFirstColumnText() {
		return this.reductionThreshold.getValue().toString();
	}

	@Override
	public Font getFont() {
		return null;
	}

	@Override
	public Color getForeground() {
		return null;
	}

	@Override
	public Image getSecondColumnImage() {
		return null;
	}

	@Override
	public String getSecondColumnText() {
		return null;
	}

	@Override
	public Image getThirdColumnImage() {
		return null;
	}

	@Override
	public String getThirdColumnText() {
		return null;
	}

	@Override
	public boolean hasChildren() 
	{
		boolean retVal = false;
		Set<ReductionLink> parentLinksOfAlarmDefinition = reductionThreshold.getAlarmDefinition().getReductionLinksForParentalarmdefid();
		for(ReductionLink link : parentLinksOfAlarmDefinition)
		{
			if(link.getType().equals(ReductionLinkType.MULTIPLICITY)) 
			{
				retVal = true;
				break;
			}
		}
		return retVal;
	}
	
	public static synchronized ReductionThreshold findReductionThreshold(ReductionThreshold redThreshold) 
	{
		ReductionThreshold retDef = null;
		retDef = ReductionThresholdHelper.reductionThresholdsMap.get(redThreshold.getAlarmDefinitionId());
		if(null == retDef) {
			try {
				if(redThreshold.getAlarmDefinitionId() == null) {
					throw new IllegalStateException("Alarm def's id is null - shouldn't happen");
				}
				redThreshold = AlarmConversationUtils.getInstance().findReductionThresholdById(redThreshold.getAlarmDefinitionId());
				AlarmConversationUtils.getInstance().hydrateReductionThreshold(redThreshold);
				
			} catch (Exception e) {
				e.printStackTrace();
				throw new RuntimeException("Could not hydrate reduction threshold", e);
			}
			ReductionThresholdHelper.reductionThresholdsMap.put(redThreshold.getAlarmDefinitionId(), redThreshold);
			retDef = redThreshold;
		}
		return retDef;
	}

	public static void clearCache() {
		reductionThresholdsMap.clear();
	}
}
