/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.tree.helpers;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

import alma.acs.tmcdb.Configuration;
import alma.acs.tmcdb.ReductionLink;
import alma.acs.tmcdb.ReductionLinkType;
import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.utils.conversation.AlarmConversationUtils;

public class ReductionLinkHelper implements ThreeColumnDomainObjectHelper 
{
	private ReductionLink reductionLink;
	@SuppressWarnings("unused")
	private Configuration configuration;
	private static Map<Integer, ReductionLink> reductionLinksMap = new HashMap<Integer, ReductionLink>();
	
	public ReductionLinkHelper(ReductionLink reductionLink, Configuration configuration) 
	{
		this.configuration = configuration;
		this.reductionLink = ReductionLinkHelper.findReductionLink(reductionLink);
	}

	public ReductionLink getReductionLink() 
	{
		return this.reductionLink;
	}
	
	@Override
	public Image getFirstColumnImage()
	{
		Image retVal = null;
		retVal = RcpUtils.getImage("icons/reductionlink.png");	
		return retVal;
	}

	@Override
	public String getFirstColumnText() 
	{
		String retVal = null;
		retVal = AlarmDefinitionHelper.getNameText(reductionLink.getAlarmDefinitionByChildalarmdefid());	
		return retVal;
	}

	@Override
	public Font getFont() {
		return null;
	}

	@Override
	public Color getForeground() {
		return null;
	}

	@Override
	public Image getSecondColumnImage() {
		return null;
	}

	@Override
	public String getSecondColumnText() {
		return null;
	}

	@Override
	public Image getThirdColumnImage() {
		return null;
	}

	@Override
	public String getThirdColumnText() {
		return null;
	}

	@Override
	public Object[] getChildren() 
	{
		Object[] retVal = null;
		
		this.reductionLink = ReductionLinkHelper.findReductionLink(reductionLink);
		if(null != reductionLink.getAlarmDefinitionByChildalarmdefid().getReductionLinksForParentalarmdefid() && 
				reductionLink.getAlarmDefinitionByChildalarmdefid().getReductionLinksForParentalarmdefid().size() > 0)
		{
			retVal = new Object[reductionLink.getAlarmDefinitionByChildalarmdefid().getReductionLinksForParentalarmdefid().size()];
			retVal = reductionLink.getAlarmDefinitionByChildalarmdefid().getReductionLinksForParentalarmdefid().toArray(retVal);
		}
			
		return retVal;
	}
	
	@Override
	public boolean hasChildren() 
	{
		boolean retVal = false;
		
		this.reductionLink = ReductionLinkHelper.findReductionLink(reductionLink);
		if(!reductionLink.getType().equals(ReductionLinkType.MULTIPLICITY)) 
		{
			if(reductionLink.getAlarmDefinitionByChildalarmdefid().getReductionLinksForParentalarmdefid().size() > 0)
			{
				retVal = true;
			}
		} 
		
		return retVal;
	}
	
	public static synchronized ReductionLink findReductionLink(ReductionLink redLin)
	{
		ReductionLink ret = null;
		if(redLin.getReductionLinkId() == null) {
			throw new IllegalStateException("ReductionLink's id is null - shouldn't happen");
		}
		ret = ReductionLinkHelper.reductionLinksMap.get(redLin.getReductionLinkId());
		if(null == ret) {
			try {
				redLin = AlarmConversationUtils.getInstance().findReductionLinkById(redLin.getReductionLinkId());
				redLin = AlarmConversationUtils.getInstance().hydrateReductionLink(redLin);
			} catch (Exception e) {
				e.printStackTrace();
				throw new RuntimeException("Could not hydrate ReductionLink", e);
			}
			ReductionLinkHelper.reductionLinksMap.put(redLin.getReductionLinkId(), redLin);
			ret = redLin;
		}
		return ret;
	}

	public static void clearCache() {
		reductionLinksMap.clear();
	}
}
