/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.tree.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

import alma.acs.tmcdb.Location;
import alma.obops.tmcdbgui.utils.conversation.AlarmConversationUtils;

public class LocationHelper implements ThreeColumnDomainObjectHelper 
{
	private static Map<Integer, Location> locationsMap = null;
	
	@Override
	public Object[] getChildren() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Image getFirstColumnImage() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getFirstColumnText() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Font getFont() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Color getForeground() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Image getSecondColumnImage() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getSecondColumnText() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Image getThirdColumnImage() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getThirdColumnText() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public boolean hasChildren() {
		// TODO Auto-generated method stub
		return false;
	}
	
	public static synchronized List<Location> getLocations()
	{
		List<Location> retLocs = new ArrayList<Location>();
		
		if(null == locationsMap) 
		{
			locationsMap = new HashMap<Integer, Location>();
			List<Location> existingLocations;
			try {
				existingLocations = AlarmConversationUtils.getInstance().findLocationsByName("");
			} catch (Exception e) {
				throw new RuntimeException("Could not get locations from database", e);
			}

			for(Location loc: existingLocations)
			{
				retLocs.add(LocationHelper.findLocation(loc));
			}
		} 
		else 
		{
			for(Entry<Integer, Location> entry : locationsMap.entrySet()) 
			{
				retLocs.add(entry.getValue());
			}
		}
		
		return retLocs;
	} 	
	
	public static synchronized Location findLocation(Location loc) 
	{
		if(null == loc) {
			return null;
		}
		
		if(null == locationsMap) 
		{
			getLocations();
		}
		
		Location ret = null;
		ret = LocationHelper.locationsMap.get(loc.getLocationId());
		if(null == ret) 
		{
			if(loc.getLocationId() == null) {
				throw new IllegalStateException("Location id is null - shouldn't happen");
			}
			LocationHelper.locationsMap.put(loc.getLocationId(), loc);
			ret = loc;
		}
		return ret;
	}
	
	public synchronized static void clearCache()
	{
		if(locationsMap != null) {
			locationsMap.clear();
			locationsMap = null;
		}
	}

}
