/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.tree.helpers;

import java.util.List;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;

/**
 * Helper class for lists (generic).
 * @author sharrington
 */
public class ListHelper implements ThreeColumnDomainObjectHelper 
{
	protected List<?> list;
	
	/**
	 * Constructor.
	 * @param list the list for which this helper class provides info.
	 */
	public ListHelper(List<?> list)
	{
		this.list = list;
	}
	
	@Override
	public Object[] getChildren() 
	{
		Object[] retVal = new Object[0];
		retVal = list.toArray( retVal );
		return retVal;
	}

	@Override
	public Image getFirstColumnImage() {
		return RcpUtils.getImage("icons/unknown.png");
	}

	@Override
	public String getFirstColumnText() {
		return "Uncategorized";
	}

	@Override
	public boolean hasChildren() {
		// A List has children if it's not empty
        return !list.isEmpty();
     }

	@Override
	public Image getSecondColumnImage() {
		return null;
	}

	@Override
	public String getSecondColumnText() {
		return null;
	}

	@Override
	public Image getThirdColumnImage() {
		return null;
	}

	@Override
	public String getThirdColumnText() {
		return null;
	}

	@Override
	public Font getFont() {
		return null;
	}

	@Override
	public Color getForeground() {
		return null;
	}

}
