/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.tree.helpers;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

import alma.acs.tmcdb.Configuration;
import alma.acs.tmcdb.FaultMember;
import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.utils.conversation.AlarmConversationUtils;

public class FaultMemberHelper implements ThreeColumnDomainObjectHelper 
{
	@SuppressWarnings("unused")
	private Configuration configuration;
	private FaultMember faultMember;
	private static Map<Integer, FaultMember> faultMembersMap = new HashMap<Integer, FaultMember>();
	
	public FaultMemberHelper(FaultMember member, Configuration configuration) 
	{
		this.faultMember = FaultMemberHelper.findFaultMember(member);
		this.configuration = configuration;
	}
	
	@Override
	public Object[] getChildren() 
	{
		return null;
	}

	@Override
	public Image getFirstColumnImage() {
		return RcpUtils.getImage("icons/faultmember.png");
	}

	@Override
	public String getFirstColumnText() {
		return faultMember.getMemberName();
	}

	@Override
	public Font getFont() {
		return null;
	}

	@Override
	public Color getForeground() {
		return null;
	}

	@Override
	public Image getSecondColumnImage() {
		return null;
	}

	@Override
	public String getSecondColumnText() {
		return null;
	}

	@Override
	public Image getThirdColumnImage() {
		return null;
	}

	@Override
	public String getThirdColumnText() {
		return null;
	}

	@Override
	public boolean hasChildren() 
	{
		return false;
	}

	public static synchronized FaultMember findFaultMember(FaultMember fm) 
	{
		FaultMember retDef = null;
		retDef = FaultMemberHelper.faultMembersMap.get(fm.getFaultMemberId());
		if(null == retDef) {
			try {
				if(fm.getFaultMemberId() == null) {
					throw new IllegalStateException("FaultMember's id is null - shouldn't happen");
				}
				fm = AlarmConversationUtils.getInstance().findFaultMemberById(fm.getFaultMemberId());
				fm = AlarmConversationUtils.getInstance().hydrateFaultMember(fm);
				
			} catch (Exception e) {
				e.printStackTrace();
				throw new RuntimeException("Could not hydrate FaultMember", e);
			}
			FaultMemberHelper.faultMembersMap.put(fm.getFaultMemberId(), fm);
			retDef = fm;
		}
		return retDef;
	}

	public static void clearCache() {
		faultMembersMap.clear();
	}
}
