/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.tree.helpers;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

import alma.acs.tmcdb.Configuration;
import alma.acs.tmcdb.DefaultMember;
import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.utils.conversation.AlarmConversationUtils;

public class DefaultMemberHelper implements ThreeColumnDomainObjectHelper 
{
	@SuppressWarnings("unused")
	private Configuration configuration;
	private static Map<Integer, DefaultMember> defaultMembersMap = new HashMap<Integer, DefaultMember>();
	
	@SuppressWarnings("unused")
	private DefaultMember defaultMember;
	
	public DefaultMemberHelper(DefaultMember member, Configuration configuration)
	{
		this.defaultMember = DefaultMemberHelper.findDefaultMember(member);
		this.configuration = configuration;
	}

	@Override
	public Object[] getChildren() {
		return null;
	}

	@Override
	public Image getFirstColumnImage() {
		return RcpUtils.getImage("icons/defaultmember.png");
	}

	@Override
	public String getFirstColumnText() {
		return "default";
	}

	@Override
	public Font getFont() {
		return null;
	}

	@Override
	public Color getForeground() {
		return null;
	}

	@Override
	public Image getSecondColumnImage() {
		return null;
	}

	@Override
	public String getSecondColumnText() {
		return null;
	}

	@Override
	public Image getThirdColumnImage() {
		return null;
	}

	@Override
	public String getThirdColumnText() {
		return null;
	}

	@Override
	public boolean hasChildren() {
		return false;
	}
	
	public static synchronized DefaultMember findDefaultMember(DefaultMember dm) 
	{
		DefaultMember ret = null;
		ret = DefaultMemberHelper.defaultMembersMap.get(dm.getDefaultMemberId());
		if(null == ret) {
			try {
				if(dm.getDefaultMemberId() == null) {
					throw new IllegalStateException("DefaultMember's id is null - shouldn't happen");
				}
				dm = AlarmConversationUtils.getInstance().findDefaultMemberById(dm.getDefaultMemberId());
				dm = AlarmConversationUtils.getInstance().hydrateDefaultMember(dm);
				
			} catch (Exception e) {
				e.printStackTrace();
				throw new RuntimeException("Could not hydrate DefaultMember", e);
			}
			DefaultMemberHelper.defaultMembersMap.put(dm.getDefaultMemberId(), dm);
			ret = dm;
		}
		return ret;
	}

	public static void clearCache() {
		defaultMembersMap.clear();
	}
}
