/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.tree.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

import alma.acs.tmcdb.Contact;
import alma.obops.tmcdbgui.utils.conversation.AlarmConversationUtils;

public class ContactHelper implements ThreeColumnDomainObjectHelper 
{
	private static Map<Integer, Contact> contactsMap = null;
	
	@Override
	public Object[] getChildren() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Image getFirstColumnImage() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getFirstColumnText() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Font getFont() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Color getForeground() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Image getSecondColumnImage() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getSecondColumnText() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Image getThirdColumnImage() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getThirdColumnText() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public boolean hasChildren() {
		// TODO Auto-generated method stub
		return false;
	}

	public static synchronized List<Contact> getContacts()
	{
		List<Contact> retVal = new ArrayList<Contact>();

		if(null == contactsMap) 
		{
			contactsMap = new HashMap<Integer, Contact>();
			List<Contact> existingContacts;
			try {
				existingContacts = AlarmConversationUtils.getInstance().findContactsByName("");
			} catch (Exception e) {
				throw new RuntimeException("Could not get contacts from database", e);
			}

			for(Contact cont: existingContacts)
			{
				retVal.add(ContactHelper.findContact(cont));
			}
		}
		else 
		{
			for(Entry<Integer, Contact> entry : contactsMap.entrySet()) 
			{
				retVal.add(entry.getValue());
			}
		}
		
		return retVal;
	} 	
	
	public static synchronized Contact findContact(Contact cont) 
	{
		if(null == contactsMap) 
		{
			getContacts();
		}
		
		
		Contact ret = null;
		ret = ContactHelper.contactsMap.get(cont.getContactId());
		if(null == ret) {
			if(cont.getContactId() == null) {
				throw new IllegalStateException("Contact id is null - shouldn't happen");
			}
			ContactHelper.contactsMap.put(cont.getContactId(), cont);
			ret = cont;
		}
		return ret;
	}

	public static synchronized void clearCache() {
		if(contactsMap != null) {
			contactsMap.clear();
			contactsMap = null;
		}
	}
}
