/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.tree.helpers;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

import alma.acs.tmcdb.Configuration;
import alma.obops.tmcdb.alarms.ui.tree.typedlists.AlarmCategoryList;
import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.utils.conversation.AlarmConversationUtils;

public class ConfigurationHelper implements ThreeColumnDomainObjectHelper 
{
	private Configuration configuration;
	private static Map<Integer, Configuration> configurationsMap = new HashMap<Integer, Configuration>();
	
	/**
	 * Constructor.
	 * @param category the AlarmCategory for which this helper class will provide info (images, text, children, etc).
	 * @param configuration 
	 */
	public ConfigurationHelper(Configuration configuration) {
		this.configuration = ConfigurationHelper.findConfiguration(configuration);
	}
	
	@Override
	public Image getFirstColumnImage() {
		return RcpUtils.getImage("icons/configuration.png");
	}

	@Override
	public String getFirstColumnText() {
		return configuration.getConfigurationName();
	}

	@Override
	public Font getFont() {
		return null;
	}

	@Override
	public Color getForeground() {
		return null;
	}

	@Override
	public Image getSecondColumnImage() {
		return null;
	}

	@Override
	public String getSecondColumnText() {
		return null;
	}

	@Override
	public Image getThirdColumnImage() {
		return null;
	}

	@Override
	public String getThirdColumnText() {
		return null;
	}

	@Override
	public boolean hasChildren() {
		return true;
	}
	
	@Override
	public Object[] getChildren() 
	{
		AlarmCategoryList acList = new AlarmCategoryList(configuration);
		Object[] retVal = new Object[1];
		retVal[0] = acList;
		return retVal;
	}

	public static synchronized Configuration findConfiguration(Configuration conf) 
	{
		Configuration ret = null;
		ret = ConfigurationHelper.configurationsMap.get(conf.getConfigurationId());
		if(null == ret) 
		{
			try 
			{
				if(conf.getConfigurationId() == null) {
					throw new IllegalStateException("Configuration's id is null - shouldn't happen");
				}
				AlarmConversationUtils.getInstance().hydrateAlarmCategories(conf);
				AlarmConversationUtils.getInstance().hydrateFaultFamilies(conf);
				AlarmConversationUtils.getInstance().hydrateReductionLinks(conf);
				AlarmConversationUtils.getInstance().hydrateAlarmDefinitions(conf);
				AlarmConversationUtils.getInstance().hydrateReductionThresholds(conf);
				AlarmConversationUtils.getInstance().hydrateReductionLinks(conf);
			} catch (Exception e) {
				e.printStackTrace();
				throw new RuntimeException("Could not hydrate configuration", e);
			}
			ConfigurationHelper.configurationsMap.put(conf.getConfigurationId(), conf);
			ret = conf;
		}
		return ret;
	}

	public static void clearCache() {
		configurationsMap.clear();
	}

}
