/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.tree.helpers;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

import alma.acs.tmcdb.AlarmCategory;
import alma.acs.tmcdb.Configuration;
import alma.acs.tmcdb.FaultFamily;
import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.utils.conversation.AlarmConversationUtils;

public class AlarmCategoryHelper implements ThreeColumnDomainObjectHelper 
{
	private AlarmCategory alarmCategory;
	@SuppressWarnings("unused")
	private Configuration configuration;
	private static Map<Integer, AlarmCategory> alarmCategoriesMap = new HashMap<Integer, AlarmCategory>();
	
	/**
	 * Constructor.
	 * @param category the AlarmCategory for which this helper class will provide info (images, text, children, etc).
	 * @param configuration 
	 */
	public AlarmCategoryHelper(AlarmCategory category, Configuration configuration) {
		this.alarmCategory = AlarmCategoryHelper.findAlarmCategory(category);
		this.configuration = configuration;
	}
	

	@Override
	public boolean hasChildren() {
		boolean retVal = false;
		retVal = (alarmCategory.getFaultFamilies() != null && alarmCategory.getFaultFamilies().size() > 0) ? true : false;
		return retVal;
	}
	
	@Override
	public Object[] getChildren() {
		FaultFamily[] retVal = new FaultFamily[alarmCategory.getFaultFamilies().size()];
		
		int count = 0;
		for(FaultFamily family : alarmCategory.getFaultFamilies()) {
			retVal[count++] = FaultFamilyHelper.findFaultFamily(family);
		}
		return retVal;
	}

	@Override
	public Image getFirstColumnImage() {
		return RcpUtils.getImage("icons/alarmcategory.png");
	}

	@Override
	public String getFirstColumnText() {
		return alarmCategory.getAlarmCategoryName();
	}

	@Override
	public Font getFont() {
		return null;
	}

	@Override
	public Color getForeground() {
		return null;
	}

	@Override
	public Image getSecondColumnImage() {
		return null;
	}

	@Override
	public String getSecondColumnText() {
		return null;
	}

	@Override
	public Image getThirdColumnImage() {
		return null;
	}

	@Override
	public String getThirdColumnText() {
		return null;
	}

	public static synchronized AlarmCategory findAlarmCategory(AlarmCategory alarmCat) 
	{
		AlarmCategory retDef = null;
		retDef = AlarmCategoryHelper.alarmCategoriesMap.get(alarmCat.getAlarmCategoryId());
		if(null == retDef) {
			try {
				if(alarmCat.getAlarmCategoryId() == null) {
					throw new IllegalStateException("AlarmCategory id is null - shouldn't happen");
				}
				alarmCat = AlarmConversationUtils.getInstance().findAlarmCategoryById(alarmCat.getAlarmCategoryId());
				alarmCat = AlarmConversationUtils.getInstance().hydrateAlarmCategory(alarmCat);
			} catch (Exception e) {
				e.printStackTrace();
				throw new RuntimeException("Could not hydrate AlarmCategory", e);
			}
			AlarmCategoryHelper.alarmCategoriesMap.put(alarmCat.getAlarmCategoryId(), alarmCat);
			retDef = alarmCat;
		}
		return retDef;
	}

	public static void clearCache() {
		alarmCategoriesMap.clear();
	}
}
