/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.editors.inputs;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

import alma.acs.tmcdb.ReductionThreshold;
import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.domain.IModelChangeListener;

public class ReductionThresholdEditorInput implements IEditorInput 
{
	private ReductionThreshold reductionThreshold;
	private IModelChangeListener modelChangeListener;

	public ReductionThresholdEditorInput(ReductionThreshold reductionThreshold, IModelChangeListener listener) 
	{
		this.reductionThreshold = reductionThreshold;
		this.modelChangeListener = listener;
	}
	
	@Override
	public boolean exists() {
		return false;
	}

	@Override
	public ImageDescriptor getImageDescriptor() {
		ImageDescriptor retVal = null;
		RcpUtils.getImageDescriptor("icons/reductionthreshold.png");
		return retVal;
	}

	@Override	
	public String getName() {
		String retVal = null;
		retVal = reductionThreshold.getValue().toString();
		return retVal;
	}

	@Override
	public IPersistableElement getPersistable() {
		return null;
	}

	@Override
	public String getToolTipText() {
		return getName();
	}

	@SuppressWarnings("unchecked")
	@Override
	public Object getAdapter(Class adapter) {
		return null;
	}

	public ReductionThreshold getReductionThreshold() {
		return reductionThreshold;
	}
	
	public boolean equals(Object o) {

		if(super.equals(o))
			return true;
		if( !(o instanceof ReductionThresholdEditorInput) )
			return false;

		ReductionThresholdEditorInput editorInput = (ReductionThresholdEditorInput)o;
		ReductionThreshold inputReductionThreshold = editorInput.getReductionThreshold();

		if( inputReductionThreshold.getAlarmDefinitionId() != null && reductionThreshold.getAlarmDefinitionId() != null ) {
			if( reductionThreshold.getAlarmDefinitionId().equals(inputReductionThreshold.getAlarmDefinitionId()) )
				return true;
			return false;
		}

		return false;
	}

	public IModelChangeListener getModelChangeListener() {
		return modelChangeListener;
	}

	@Override
	public int hashCode() {
		int retVal = 17;
		retVal += (this.getReductionThreshold() == null)? 0 : this.getReductionThreshold().hashCode();
		return retVal;
	}
}
