/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.editors.inputs;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

import alma.acs.tmcdb.ReductionLink;
import alma.acs.tmcdb.ReductionLinkType;
import alma.obops.tmcdb.alarms.ui.tree.helpers.AlarmDefinitionHelper;
import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.domain.IModelChangeListener;

public class ReductionLinkEditorInput implements IEditorInput 
{
	private ReductionLink reductionLink;
	private IModelChangeListener modelChangeListener;

	public ReductionLinkEditorInput(ReductionLink reductionLink, IModelChangeListener listener) 
	{
		this.reductionLink = reductionLink;
		this.modelChangeListener = listener;
	}
	
	@Override
	public boolean exists() {
		return false;
	}

	@Override
	public ImageDescriptor getImageDescriptor() {
		ImageDescriptor retVal = null;
		if(reductionLink.getType().equals(ReductionLinkType.NODE)) {
			RcpUtils.getImageDescriptor("icons/node-reduction.png");
		} else {
			RcpUtils.getImageDescriptor("icons/multiplicity-reduction.png");
		}
		return retVal;
	}

	@Override	
	public String getName() {
		String retVal = null;
		if(null != reductionLink && reductionLink.getType().equals(ReductionLinkType.NODE))
		{
			retVal = AlarmDefinitionHelper.getNameText(reductionLink.getAlarmDefinitionByChildalarmdefid());
		}
		else if(null != reductionLink)
		{
			retVal = AlarmDefinitionHelper.getNameText(reductionLink.getAlarmDefinitionByParentalarmdefid());
		}
		return retVal;
	}

	@Override
	public IPersistableElement getPersistable() {
		return null;
	}

	@Override
	public String getToolTipText() {
		return getName();
	}

	@SuppressWarnings("unchecked")
	@Override
	public Object getAdapter(Class adapter) {
		return null;
	}

	public ReductionLink getReductionLink() {
		return reductionLink;
	}
	
	public boolean equals(Object o) {

		if(super.equals(o))
			return true;
		if( !(o instanceof ReductionLinkEditorInput) )
			return false;

		ReductionLinkEditorInput editorInput = (ReductionLinkEditorInput)o;
		ReductionLink inputReductionLink = editorInput.getReductionLink();

		if( inputReductionLink.getReductionLinkId() != null && reductionLink.getReductionLinkId() != null ) {
			if( reductionLink.getReductionLinkId().equals(inputReductionLink.getReductionLinkId()) )
				return true;
			return false;
		}

		return false;
	}

	public IModelChangeListener getModelChangeListener() {
		return modelChangeListener;
	}

	@Override
	public int hashCode() {
		int retVal = 17;
		retVal += this.getReductionLink() == null ? 0: this.getReductionLink().hashCode();
		return retVal;
	}
}
