/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.editors.inputs;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

import alma.acs.tmcdb.FaultMember;
import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.domain.IModelChangeListener;

public class FaultMemberEditorInput implements IEditorInput 
{
	private FaultMember faultMember;
	private IModelChangeListener modelChangeListener;

	public FaultMemberEditorInput(FaultMember faultMember, IModelChangeListener listener) 
	{
		this.faultMember = faultMember;
		this.modelChangeListener = listener;
	}
	
	@Override
	public boolean exists() {
		return false;
	}

	@Override
	public ImageDescriptor getImageDescriptor() {
		return RcpUtils.getImageDescriptor("icons/faultmember.png");
	}

	@Override	
	public String getName() {
		return (faultMember != null) ? faultMember.getMemberName() : "";
	}

	@Override
	public IPersistableElement getPersistable() {
		return null;
	}

	@Override
	public String getToolTipText() {
		return getName();
	}

	@SuppressWarnings("unchecked")
	@Override
	public Object getAdapter(Class adapter) {
		return null;
	}

	public FaultMember getFaultMember() {
		return faultMember;
	}
	
	public boolean equals(Object o) {

		if(super.equals(o))
			return true;
		if( !(o instanceof FaultMemberEditorInput) )
			return false;

		FaultMemberEditorInput editorInput = (FaultMemberEditorInput)o;
		FaultMember inputFaultMember = editorInput.getFaultMember();

		if( inputFaultMember.getFaultMemberId() != null && faultMember.getFaultMemberId() != null ) {
			if( faultMember.getFaultMemberId().equals(inputFaultMember.getFaultMemberId()) )
				return true;
			return false;
		}

		return false;
	}

	public IModelChangeListener getModelChangeListener() {
		return modelChangeListener;
	}

	@Override
	public int hashCode() {
		int retVal = 17;
		retVal += (this.getFaultMember() == null || this.getFaultMember().getFaultMemberId() == null) 
		   ? 0 : this.getFaultMember().getFaultMemberId().hashCode();
		return retVal;
	}
}
