/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.editors.inputs;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

import alma.acs.tmcdb.FaultCode;
import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.domain.IModelChangeListener;

public class FaultCodeEditorInput implements IEditorInput 
{
	private FaultCode faultCode;
	private IModelChangeListener modelChangeListener;

	public FaultCodeEditorInput(FaultCode faultCode, IModelChangeListener listener) 
	{
		this.faultCode = faultCode;
		this.modelChangeListener = listener;
	}
	
	@Override
	public boolean exists() {
		return false;
	}

	@Override
	public ImageDescriptor getImageDescriptor() {
		return RcpUtils.getImageDescriptor("icons/faultcode.png");
	}

	@Override	
	public String getName() {
		return (faultCode != null) ? faultCode.getCodeValue().toString() : "";
	}

	@Override
	public IPersistableElement getPersistable() {
		return null;
	}

	@Override
	public String getToolTipText() {
		return getName();
	}

	@SuppressWarnings("unchecked")
	@Override
	public Object getAdapter(Class adapter) {
		return null;
	}

	public FaultCode getFaultCode() {
		return this.faultCode;
	}
	
	@Override
	public boolean equals(Object obj) 
	{
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		final FaultCodeEditorInput other = (FaultCodeEditorInput) obj;
		if (this.faultCode == null) {
			if (other.faultCode != null) {
				return false;
			}
		} else if (!this.faultCode.getFaultCodeId().equals(other.faultCode.getFaultCodeId())) {
			return false;
		}
		return true;
	}

	
	@Override
    public int hashCode() 
	{
        final int prime = 31;
        int result = 1;
        result = prime * result + (faultCode == null ? 0 : faultCode.getFaultCodeId());
        return result;
    }


	public IModelChangeListener getModelChangeListener() {
		return modelChangeListener;
	}
}
