/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.actions.edit;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory.IWorkbenchAction;

import alma.acs.tmcdb.ReductionLink;
import alma.acs.tmcdb.ReductionLinkType;
import alma.obops.tmcdb.alarms.ui.editors.ReductionLinkEditor;
import alma.obops.tmcdb.alarms.ui.editors.inputs.ReductionLinkEditorInput;
import alma.obops.tmcdb.alarms.ui.perspectives.AlarmsPerspective;
import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.domain.IModelChangeListener;

public class EditReductionLinkAction extends Action implements ISelectionListener, IWorkbenchAction  
{
	private IStructuredSelection _selection;
	private IWorkbenchWindow _window;
	private String ID = "alma.obops.tmcdb.alarms.ui.actions.EditAlarmDefinitionAction";
	private IModelChangeListener modelChangeListener;
	private ReductionLink currentlySelectedReductionLink;

	public EditReductionLinkAction(IWorkbenchWindow window, IModelChangeListener listener)
	{
		_window = window;
    	setId(ID);
        setInfo();
		this.modelChangeListener = listener;
    	_window.getSelectionService().addSelectionListener(this);	
	}

	private void setInfo() 
	{
		if(this.currentlySelectedReductionLink == null || this.currentlySelectedReductionLink.getType().equals(ReductionLinkType.NODE))
		{
			setText("Edit Node Reduction Link");
			setToolTipText("Opens the node reduction link in an editor");
			setImageDescriptor(RcpUtils.getImageDescriptor("icons/node-reduction.png"));
		}
		else 
		{
			setText("Edit Multiplicity Reduction Link");
			setToolTipText("Opens the multiplicity reduction link in an editor");
			setImageDescriptor(RcpUtils.getImageDescriptor("icons/multiplicity-reduction.png"));
		}
	}
	
	public void run() 
	{
		try {
			ReductionLink redLink = (ReductionLink)_selection.getFirstElement();
			ReductionLinkEditorInput editorInput = new ReductionLinkEditorInput(redLink, modelChangeListener);
			_window.getWorkbench().showPerspective(AlarmsPerspective.ID, _window);
			_window.getActivePage().openEditor(editorInput, ReductionLinkEditor.ID);	
			
		} catch (Exception ex) {
			ex.printStackTrace();
			throw new RuntimeException("Problem editing reduction link", ex);
		}
	}

	@Override
	public void selectionChanged(IWorkbenchPart part, ISelection selection) 
	{
		if( selection instanceof IStructuredSelection ) 
		{
			_selection = (IStructuredSelection)selection;
			if( _selection.size() == 1 &&
		            _selection.getFirstElement() instanceof ReductionLink && 
		            ((ReductionLink) _selection.getFirstElement()).getType().equals(ReductionLinkType.NODE))
			{
				setEnabled(true);	
				this.currentlySelectedReductionLink = ((ReductionLink) _selection.getFirstElement());
			}
			else 
			{
				setEnabled(false);
				this.currentlySelectedReductionLink = null;
			}
			setInfo();
		}
	}

	@Override
	public void dispose() {
		_window.getSelectionService().removeSelectionListener(this);
	}
}
