/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.actions.edit;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory.IWorkbenchAction;

import alma.acs.tmcdb.FaultCode;
import alma.obops.tmcdb.alarms.ui.editors.FaultCodeEditor;
import alma.obops.tmcdb.alarms.ui.editors.inputs.FaultCodeEditorInput;
import alma.obops.tmcdb.alarms.ui.perspectives.AlarmsPerspective;
import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.domain.IModelChangeListener;

public class EditFaultCodeAction extends Action implements ISelectionListener, IWorkbenchAction 
{
	private IStructuredSelection _selection;
	private IWorkbenchWindow _window;
	private String ID = "alma.obops.tmcdb.alarms.ui.actions.EditFaultCodeAction";
	private IModelChangeListener modelChangeListener;

	public EditFaultCodeAction(IWorkbenchWindow window, IModelChangeListener listener)
	{
		_window = window;
    	setId(ID);
        setText("Edit Fault Code");
		setToolTipText("Opens the Fault Code in an editor");
		setImageDescriptor(RcpUtils.getImageDescriptor("icons/faultcode.png"));
		this.modelChangeListener = listener;
    	_window.getSelectionService().addSelectionListener(this);	
	}
	
	public void run() 
	{
		try {
			FaultCode faultCode = (FaultCode)_selection.getFirstElement();
			FaultCodeEditorInput editorInput = new FaultCodeEditorInput(faultCode, modelChangeListener);
			_window.getWorkbench().showPerspective(AlarmsPerspective.ID, _window);
			_window.getActivePage().openEditor(editorInput, FaultCodeEditor.ID);
		} catch (Exception ex) {
			ex.printStackTrace();
			throw new RuntimeException("Problem editing fault code", ex);
		}
	}

	@Override
	public void selectionChanged(IWorkbenchPart part, ISelection selection) 
	{
		if( selection instanceof IStructuredSelection ) 
		{
			_selection = (IStructuredSelection)selection;
			setEnabled( _selection.size() == 1 &&
			            _selection.getFirstElement() instanceof FaultCode);	
		}
	}

	@Override
	public void dispose() {
		_window.getSelectionService().removeSelectionListener(this);
	}
}
