/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.tmcdb.alarms.ui.actions.edit;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory.IWorkbenchAction;

import alma.acs.tmcdb.DefaultMember;
import alma.obops.tmcdb.alarms.ui.editors.DefaultMemberEditor;
import alma.obops.tmcdb.alarms.ui.editors.inputs.DefaultMemberEditorInput;
import alma.obops.tmcdb.alarms.ui.perspectives.AlarmsPerspective;
import alma.obops.tmcdb.alarms.ui.tree.helpers.DefaultMemberHelper;
import alma.obops.tmcdb.alarms.ui.utils.RcpUtils;
import alma.obops.tmcdbgui.domain.IModelChangeListener;

public class EditDefaultMemberAction extends Action implements ISelectionListener, IWorkbenchAction 
{
	private IStructuredSelection _selection;
	private IWorkbenchWindow _window;
	private String ID = "alma.obops.tmcdb.alarms.ui.actions.EditFaultMemberAction";
	private IModelChangeListener modelChangeListener;

	public EditDefaultMemberAction(IWorkbenchWindow window, IModelChangeListener listener)
	{
		_window = window;
    	setId(ID);
        setText("Edit Default Member");
		setToolTipText("Opens the Default Member in an editor");
		setImageDescriptor(RcpUtils.getImageDescriptor("icons/defaultmember.png"));
		this.modelChangeListener = listener;
    	_window.getSelectionService().addSelectionListener(this);	
	}
	
	public void run() 
	{
		try {
			DefaultMember defaultMember = (DefaultMember)_selection.getFirstElement();
			defaultMember = DefaultMemberHelper.findDefaultMember(defaultMember);
			DefaultMemberEditorInput editorInput = new DefaultMemberEditorInput(defaultMember, modelChangeListener);
			_window.getWorkbench().showPerspective(AlarmsPerspective.ID, _window);
			_window.getActivePage().openEditor(editorInput, DefaultMemberEditor.ID);
		} catch (Exception e) {
			throw new RuntimeException("Problem editing default member", e);
		}
	}

	@Override
	public void selectionChanged(IWorkbenchPart part, ISelection selection) 
	{
		if( selection instanceof IStructuredSelection ) 
		{
			_selection = (IStructuredSelection)selection;
			setEnabled( _selection.size() == 1 &&
			            _selection.getFirstElement() instanceof DefaultMember);	
		}
	}

	@Override
	public void dispose() {
		_window.getSelectionService().removeSelectionListener(this);
	}
}
