/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * TestAntennaService.java
 *
 * Copyright European Southern Observatory 2008
 */

package alma.obops.dam.tmcdb.service;

import static alma.obops.dam.testutils.TmcdbTestConstants.CONFIG_NAME0;
import static alma.obops.dam.testutils.TmcdbTestConstants.PAD_NAME0;
import static alma.obops.dam.testutils.TmcdbTestConstants.PAD_NAME1;
import static alma.obops.dam.testutils.TmcdbTestConstants.URN0;

import java.util.List;

import alma.obops.dam.ServiceException;
import alma.obops.dam.testutils.TmcdbTestCase;
import alma.obops.dam.testutils.TmcdbTestCreationHelper;
import alma.tmcdb.domain.Coordinate;
import alma.tmcdb.domain.HwConfiguration;
import alma.tmcdb.domain.Pad;

/**
 * @author rkurowsk, Feb 18, 2009
 * 
 */



public class TestPadService extends TmcdbTestCase {

    // obtain these DAOs through dependency injection
    private TmcdbTestCreationHelper creationHelper;
    private PadService padService;
    
    // Basic creation test
    @SuppressWarnings("unchecked")
	public void testCreate00() throws ServiceException {        
    	
    	HwConfiguration config = creationHelper.createConfiguration(CONFIG_NAME0);
    	
		creationHelper.createSchema(URN0, "data", config );

        // detach above objects
        commitAndStartNewTransaction();
        
		Coordinate coord = new Coordinate(123d, 345d, 678d);
		Pad pad = new Pad(PAD_NAME0, coord, System.currentTimeMillis());
		config.addBaseElement(pad);
		
		padService.create(pad);
        
        commitAndStartNewTransaction();
        
        List<Pad> beOut = (List<Pad>)tmcdbDao.findAll(Pad.class);
        assertNotNull( beOut );
        assertEquals( 1, beOut.size() );
        assertEquals( pad.getId(), beOut.get( 0 ).getId() );
        
        HwConfiguration out = (HwConfiguration) tmcdbDao.read( config.getId(), HwConfiguration.class );
        assertNotNull( out.getBaseElements() );
        assertEquals(  1, out.getBaseElements().size() );

    }


    // Double creation test
    @SuppressWarnings("unchecked")
	public void testCreate02() throws ServiceException {        // Create and save an Antenna
       
    	HwConfiguration config = creationHelper.createConfiguration(CONFIG_NAME0);
    	
		creationHelper.createSchema(URN0, "data", config );
        
        // detach above objects
        commitAndStartNewTransaction();
        
		Coordinate coord = new Coordinate(123d, 345d, 678d);
		Pad pad0 = new Pad(PAD_NAME0, coord, System.currentTimeMillis());
		config.addBaseElement(pad0);
		
		padService.create(pad0);                  

        commitAndStartNewTransaction();
        
		Coordinate coord1 = new Coordinate(123d, 345d, 678d);
		Pad pad1 = new Pad(PAD_NAME1, coord1, System.currentTimeMillis());
        
		config.addBaseElement(pad1);
		padService.create(pad1);                  

        commitAndStartNewTransaction();
        
        List<Pad> beOut = (List<Pad>)tmcdbDao.findAll(Pad.class);
        assertNotNull( beOut );
        assertEquals( 2, beOut.size() );
        assertEquals( pad0.getId(), beOut.get( 0 ).getId() );
        assertEquals( pad1.getId(), beOut.get( 1 ).getId() );
        
        HwConfiguration out = (HwConfiguration) tmcdbDao.read( config.getId(), HwConfiguration.class );
        assertNotNull( out.getBaseElements() );
        assertEquals(  2, out.getBaseElements().size() );
          
    }

	public void setCreationHelper(TmcdbTestCreationHelper creationHelper) {
		this.creationHelper = creationHelper;
	}

	public void setPadService(PadService padService) {
		this.padService = padService;
	}

}
