/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * TestAssemblyTypeService.java
 *
 * Copyright European Southern Observatory 2008
 */

package alma.obops.dam.tmcdb.service;

import static alma.obops.dam.testutils.TmcdbTestConstants.ASSEMBLY_TYPE_NAME_0;
import static alma.obops.dam.testutils.TmcdbTestConstants.CONFIG_NAME0;
import static alma.obops.dam.testutils.TmcdbTestConstants.IDL0;
import static alma.obops.dam.testutils.TmcdbTestConstants.LRU_DESC;
import static alma.obops.dam.testutils.TmcdbTestConstants.LRU_FULLNAME;
import static alma.obops.dam.testutils.TmcdbTestConstants.LRU_ICD;
import static alma.obops.dam.testutils.TmcdbTestConstants.LRU_ICD_DATE;
import static alma.obops.dam.testutils.TmcdbTestConstants.LRU_NAME_0;
import static alma.obops.dam.testutils.TmcdbTestConstants.LRU_NOTES;
import static alma.obops.dam.testutils.TmcdbTestConstants.URN0;

import java.util.List;

import alma.acs.tmcdb.ComponentType;
import alma.obops.dam.testutils.TmcdbTestCase;
import alma.obops.dam.testutils.TmcdbTestCreationHelper;
import alma.tmcdb.domain.AssemblyType;
import alma.tmcdb.domain.BaseElementType;
import alma.tmcdb.domain.HwConfiguration;
import alma.tmcdb.domain.LruType;

/**
 * @author rkurowsk, Dec 12, 2008
 * 
 */



public class TestAssemblyTypeService extends TmcdbTestCase {

	// obtain this service using service factory
	private AssemblyTypeService assemblyTypeService;

	private TmcdbTestCreationHelper creationHelper;
    
	/*
	 * Setters for dependency injection
	 */
	public void setCreationHelper(TmcdbTestCreationHelper creationHelper) {
		this.creationHelper = creationHelper;
	}

	public void setAssemblyTypeService(AssemblyTypeService assemblyTypeService) {
		this.assemblyTypeService = assemblyTypeService;
	}

	// Basic creation test
	@SuppressWarnings("unchecked")
	public void testCreate00() {

		// Create and save an AssemblyType using the service
		AssemblyType assemblyType0 = newAssemblyType(ASSEMBLY_TYPE_NAME_0, URN0, IDL0, CONFIG_NAME0);
		
        // detach above objects
        commitAndStartNewTransaction();
        
		this.assemblyTypeService.create(assemblyType0);

		commitAndStartNewTransaction();
		
		List<AssemblyType> assemblyTypeOut = (List<AssemblyType>) tmcdbDao.findAll(AssemblyType.class);
		assertNotNull(assemblyTypeOut);
		assertEquals(1, assemblyTypeOut.size());
		assertEquals(assemblyType0.getName(), assemblyTypeOut.get(0).getName());

	}

//	// Double creation test
//	public void testCreate01() { 
//
//		// Create and save 2 AssemblyTypes using the service
//		AssemblyType assemblyType0 = newAssemblyType(ASSEMBLY_TYPE_NAME_0);
//		this.assemblyTypeService.create(assemblyType0);
//
//		AssemblyType assemblyType1 = newAssemblyType(ASSEMBLY_TYPE_NAME_1);
//		this.assemblyTypeService.create(assemblyType1);
//
//		List<AssemblyType> assemblyTypeOut = tmcdbDao.findAll();
//		assertNotNull(assemblyTypeOut);
//		assertEquals(2, assemblyTypeOut.size());
//		assertEquals(assemblyType0.getAssemblyName(), assemblyTypeOut.get(0).getAssemblyName());
//
//	}
	
	private AssemblyType newAssemblyType(String assemblyName, String urn, String idl, String configName) {
		
		HwConfiguration config = creationHelper.createConfiguration(configName);
		
		LruType lruType = new LruType(LRU_NAME_0, LRU_FULLNAME, LRU_ICD, LRU_ICD_DATE, LRU_DESC, LRU_NOTES);
		
		tmcdbDao.create(lruType);
		
		// AssemblyType has a schema so we create a persisted one
		this.creationHelper.createSchema(urn, idl, config);
		ComponentType componentType = this.creationHelper.createComponentType(idl);

		commitAndStartNewTransaction();
		
		AssemblyType at = new AssemblyType(assemblyName, "assemblyFullName", BaseElementType.Antenna, "description", "notes", componentType, "productionCode", "simulatedCode");
		at.setLruType(lruType);
		
		return at;
		
	}
}
