/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * TestAntennaService.java
 *
 * Copyright European Southern Observatory 2008
 */

package alma.obops.dam.tmcdb.service;

import static alma.obops.dam.testutils.TmcdbTestConstants.ANTENNA_NAME0;
import static alma.obops.dam.testutils.TmcdbTestConstants.ANTENNA_NAME1;
import static alma.obops.dam.testutils.TmcdbTestConstants.COMPONENT_NAME0;
import static alma.obops.dam.testutils.TmcdbTestConstants.CONFIG_NAME0;
import static alma.obops.dam.testutils.TmcdbTestConstants.IDL0;
import static alma.obops.dam.testutils.TmcdbTestConstants.IDL1;
import static alma.obops.dam.testutils.TmcdbTestConstants.URN0;
import static alma.obops.dam.testutils.TmcdbTestConstants.URN1;

import java.util.List;

import alma.acs.tmcdb.ComponentType;
import alma.obops.dam.ServiceException;
import alma.obops.dam.testutils.TmcdbTestCase;
import alma.obops.dam.testutils.TmcdbTestCreationHelper;
import alma.tmcdb.domain.Antenna;
import alma.tmcdb.domain.AntennaType;
import alma.tmcdb.domain.BaseElement;
import alma.tmcdb.domain.BaseElementType;
import alma.tmcdb.domain.Coordinate;
import alma.tmcdb.domain.HwConfiguration;

/**
 * @author amchavan, Sep 11, 2008
 * 
 */



public class TestAntennaService extends TmcdbTestCase {
    
    // obtain this service using service factory
    private AntennaService antennaService;
    
    private TmcdbTestCreationHelper creationHelper;
    
	/*
	 * Setters for dependency injection
	 */
	public void setCreationHelper(TmcdbTestCreationHelper creationHelper) {
		this.creationHelper = creationHelper;
	}

	public void setAntennaService(AntennaService antennaService) {
		this.antennaService = antennaService;
	}

    // Basic creation test
    @SuppressWarnings("unchecked")
	public void testCreate00() throws ServiceException {        
    	
    	// Create and save an Antenna
    	HwConfiguration config = creationHelper.createConfiguration(CONFIG_NAME0);
    	/*Schema schema = */creationHelper.createSchema(URN0, IDL0,  config);
    	creationHelper.createComponentType(IDL0);

        // detach above objects
        commitAndStartNewTransaction();
        
        Antenna ant = new Antenna(ANTENNA_NAME0, AntennaType.ACA, new Coordinate(1d, 2d, 3d), new Coordinate(1d, 2d, 3d), 123d, System.currentTimeMillis(), 0, 0);
        config.addBaseElement(ant);
                
        this.antennaService.create( ant);                  
        
        List<Antenna> antOut = (List<Antenna>)tmcdbDao.findAll(Antenna.class);
        assertNotNull( antOut );
        assertEquals( 1, antOut.size() );
        assertEquals( ant.getId(), antOut.get( 0 ).getId() );

        HwConfiguration out = (HwConfiguration) tmcdbDao.read( config.getId(), HwConfiguration.class);
        assertNotNull( out.getBaseElements() );
        
        int numAntennas = 0;
        for(BaseElement be: out.getBaseElements()){
        	if(be.getType() == BaseElementType.Antenna){
        		numAntennas++;
        	}
        }
        assertEquals(1, numAntennas);

    }


    // Double creation test
    @SuppressWarnings("unchecked")
	public void testCreate02() throws ServiceException {        // Create and save an Antenna
       
    	HwConfiguration config0 = creationHelper.createConfiguration(CONFIG_NAME0);
    	creationHelper.createSchema(URN0, IDL0,  config0);
    	ComponentType ctype0 = creationHelper.createComponentType(IDL0);
        creationHelper.createComponent(COMPONENT_NAME0, config0, ctype0, URN0 );
        
        // detach above objects
        commitAndStartNewTransaction();
        
        Antenna ant = new Antenna(ANTENNA_NAME0, AntennaType.ACA, new Coordinate(1d, 2d, 3d), new Coordinate(1d, 2d, 3d), 123d, System.currentTimeMillis(), 0, 0);
        config0.addBaseElement(ant);
        
        this.antennaService.create( ant );                   
            
    	/*Schema schema1 = */creationHelper.createSchema(URN1, IDL1,  config0);
        
        Antenna ant1 = new Antenna(ANTENNA_NAME1, AntennaType.ACA, new Coordinate(1d, 2d, 3d), new Coordinate(1d, 2d, 3d), 123d, System.currentTimeMillis(), 0, 0);
        config0.addBaseElement(ant1);
        
        this.antennaService.create( ant1 );                     
          
        List<Antenna> antOut =(List<Antenna>)tmcdbDao.findAll(Antenna.class);
        assertNotNull( antOut );
        assertEquals( 2, antOut.size() );
        assertEquals( ant.getId(), antOut.get( 0 ).getId() );
    
        HwConfiguration out = (HwConfiguration) tmcdbDao.read( config0.getId(), HwConfiguration.class);
        assertNotNull( out.getBaseElements() );
        
        int numAntennas = 0;
        for(BaseElement be: out.getBaseElements()){
        	if(be.getType() == BaseElementType.Antenna){
        		numAntennas++;
        	}
        }
        assertEquals(2, numAntennas);
    }

}
