/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.dam.tmcdb.service;

import junit.framework.Test;
import junit.framework.TestSuite;
import alma.obops.utils.GeneralUtils;

/**
 * "All tests" file for tests running against sample tmcdb. NOTE: this is a separate test suite
 * in order to allow us to run most dam tests against one archiveConfig.properties file, while running
 * the sample tmcdb tests against another archiveConfig.properties file. Given the spring test environment
 * this is not easy to do within the spring test framework proper; consequently, we simply run 2 tests
 * back to back in our testAll shell script.
 * 
 * @author sharrington
 */
public class SampleTmcdbAllTests 
{
	public static Test suite() 
	{
		TestSuite suite = new TestSuite( "Test for alma.obops.dam.tmcdb.service related to sample tmcdb database" );
		GeneralUtils.setLogLevel( "WARNING" );

		//$JUnit-BEGIN$
		suite.addTestSuite( TestConversationInterceptor.class );
		suite.addTestSuite( TestCloneWithSampleTmcdbDatabase.class );
		//$JUnit-END$
		return suite;
	}
}
