/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/

package alma.obops.dam.tmcdb.dao;

import static alma.obops.dam.testutils.TmcdbTestConstants.ANTENNA_NAME0;
import static alma.obops.dam.testutils.TmcdbTestConstants.CONFIG_NAME0;
import static alma.obops.dam.testutils.TmcdbTestConstants.IDL0;
import static alma.obops.dam.testutils.TmcdbTestConstants.PAD_NAME0;
import static alma.obops.dam.testutils.TmcdbTestConstants.URN0;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;

import alma.obops.dam.testutils.TmcdbTestCase;
import alma.obops.dam.testutils.TmcdbTestCreationHelper;
import alma.tmcdb.domain.Antenna;
import alma.tmcdb.domain.AntennaToPad;
import alma.tmcdb.domain.AntennaType;
import alma.tmcdb.domain.HwConfiguration;
import alma.tmcdb.domain.Pad;

/**
 * 
 * @author amchavan, Sep 11, 2007
 */



public class TestAntennaToPad extends TmcdbTestCase {

    private TmcdbTestCreationHelper creationHelper;

	/*
	 * Setters for dependency injection
	 */
	public void setCreationHelper(TmcdbTestCreationHelper creationHelper) {
		this.creationHelper = creationHelper;
	}

    // Basic creation test
    public void testCreate00( ) 
        throws SQLException {

        createConnectedAntennaPad();

        // New session
        //--------------------------------------
        commitAndStartNewTransaction();
        
        // Now do an independent query on the database to see whether it's
        // really there
        String sql = "select count(*) from AntennaToPad";
        ResultSet rs = hibernateUtils.query( sql );
        rs.next();
        int count = rs.getInt( 1 );
        assertEquals( 1, count );
    }  

	private Antenna createConnectedAntennaPad(){
		HwConfiguration config = creationHelper.createConfiguration(CONFIG_NAME0);
		
		/*Schema schema = */creationHelper.createSchema(URN0, IDL0, config);
		// Create and save an Antenna and a Pad
    	Antenna ant = creationHelper.createAntenna(ANTENNA_NAME0, AntennaType.ACA, 
    			config);
		
		
		Pad pad = creationHelper.createPad(PAD_NAME0, config);
		// New session
		// --------------------------------------
		commitAndStartNewTransaction();

//		// Reload our objects
//		Antenna ant2 = (Antenna) tmcdbDao.read(ant.getId());
//		Pad pad2 = (Pad) tmcdbDao.read(pad.getId());

		// Create an AntennaToPad two-way link
		AntennaToPad a2p = new AntennaToPad(ant, pad, 0l, 0l, true);
		tmcdbDao.create(a2p);
	
		return ant;
	}


    // Basic creation test
    public void testCreate01( ) 
    {
        Antenna ant = createConnectedAntennaPad();
        
        // New session
        //--------------------------------------
        commitAndStartNewTransaction();
        
        // Reload the Antenna, navigate to the Pad
        Antenna ant3 = (Antenna) tmcdbDao.read( ant.getId(), Antenna.class);
        Set<AntennaToPad> refs = ant3.getScheduledPadLocations();
        assertNotNull( refs );
        assertEquals( 1, refs.size() );
        
        
        Pad pad3 = refs.iterator().next().getPad();
        assertNotNull( pad3 );

        // New session
        //--------------------------------------
//        won't work, Hibernate is instrumenting my code here...
//        commitAndStartNewTransaction();
        
        // Reload the Pad, navigate back to the Antenna
        Pad pad4 = (Pad) tmcdbDao.read( pad3.getId(), Pad.class );
        Set<AntennaToPad> backRefs = pad4.getScheduledAntennas();
        assertNotNull( backRefs );
        assertEquals( 1, backRefs.size() );

        AntennaToPad backRef = backRefs.iterator().next();
        Antenna ant4 = backRef.getAntenna();
        assertNotNull( ant4 );
        assertEquals(  ant3.getId(), ant4.getId() );
    }

}
