/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.dam.utils.xstream;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

import org.hibernate.collection.PersistentBag;
import org.hibernate.collection.PersistentList;
import org.hibernate.collection.PersistentMap;
import org.hibernate.collection.PersistentSet;
import org.hibernate.collection.PersistentSortedMap;
import org.hibernate.collection.PersistentSortedSet;
import org.hibernate.proxy.HibernateProxy;

import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;

public class HibernateMapper extends MapperWrapper {

    	Map<Class<?>,Class<?>> collectionMap = new HashMap<Class<?>, Class<?>>();

		public void init() {
			collectionMap.put(PersistentBag.class,ArrayList.class);
			collectionMap.put(PersistentList.class,ArrayList.class);
			collectionMap.put(PersistentMap.class,HashMap.class);
			collectionMap.put(PersistentSet.class,Set.class);
			collectionMap.put(PersistentSortedMap.class,SortedMap.class);
			collectionMap.put(PersistentSortedSet.class,SortedSet.class);
		}
	
		public HibernateMapper(Mapper arg0) {
			super(arg0);
			init();
		}

		@SuppressWarnings("unchecked")
		public Class<?> defaultImplementationOf(Class clazz) {
			if(collectionMap.containsKey(clazz)) {
				return collectionMap.get(clazz);	
			}

			return super.defaultImplementationOf(clazz);
		}

		@SuppressWarnings("unchecked")
		public String serializedClass(Class clazz) {
			// check whether we are hibernate proxy and substitute real name
			for(int i = 0; i < clazz.getInterfaces().length;i++) {
				if(HibernateProxy.class.equals(clazz.getInterfaces()[i])){
					return clazz.getSuperclass().getName();
				}
			}
			if(collectionMap.containsKey(clazz)) {
				return ((Class<?>) collectionMap.get(clazz)).getName();	
			}
			
			return super.serializedClass(clazz);
		}
    	
    }