/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.dam.utils.xstream;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.TreeSet;

import org.hibernate.collection.PersistentList;
import org.hibernate.collection.PersistentMap;
import org.hibernate.collection.PersistentSet;
import org.hibernate.collection.PersistentSortedMap;
import org.hibernate.collection.PersistentSortedSet;

import com.thoughtworks.xstream.mapper.AbstractXmlFriendlyMapper;
import com.thoughtworks.xstream.mapper.Mapper;

public class HibernateCollectionsMapper extends AbstractXmlFriendlyMapper
    {
        private final  String[] hbClassNames = {
                PersistentList.class.getName(), PersistentSet.class.getName(),
                PersistentMap.class.getName(), PersistentSortedSet.class.getName(),
                PersistentSortedMap.class.getName() };

        private final  String[] jdkClassNames = { ArrayList.class.getName(),
                HashSet.class.getName(), HashMap.class.getName(),
                TreeSet.class.getName(), TreeMap.class.getName() };

        private final  Class<?>[] hbClasses = { PersistentList.class,
                PersistentSet.class, PersistentMap.class,
                PersistentSortedSet.class, PersistentSortedMap.class };

        private final  Class<?>[] jdkClasses = { ArrayList.class, HashSet.class,
                HashMap.class, TreeSet.class, TreeMap.class };

        public HibernateCollectionsMapper(Mapper wrapped)
        {
            super(wrapped);
        }

        /**
         * @see com.thoughtworks.xstream.alias.ClassMapper#mapNameToXML(java.lang.String)
         */
        public String mapNameToXML(String javaName)
        {
            return escapeFieldName(replaceClasses(javaName));
        }

        /**
         * @see com.thoughtworks.xstream.mapper.Mapper#serializedClass(java.lang.Class)
         */
        @SuppressWarnings("unchecked")
		public String serializedClass(Class type)
        {
            return super.serializedClass(replaceClasses(type));
        }

        /**
         * @see com.thoughtworks.xstream.mapper.Mapper#serializedMember(java.lang.Class, java.lang.String)
         */
        @SuppressWarnings("unchecked")
		public String serializedMember(Class type, String fieldName)
        {
            return super.serializedMember(replaceClasses(type), fieldName);
        }

        /**
         * Simple replacements between the HB 3 collections and their underlying collections from java.util.
         * 
         * @param name
         * @return the equivalent JDK class name
         */
        private String replaceClasses(String name)
        {
            for (int i = 0; i < hbClassNames.length; i++)
            {
                if (name.equals(hbClassNames[i]))
                    return jdkClassNames[i];
            }
            return name;
        }

        /**
         * Simple replacements between the HB 3 collections and their underlying collections from java.util.
         * 
         * @param clazz
         * @return the equivalent JDK class
         */
		@SuppressWarnings("unchecked")
		private Class<?> replaceClasses(Class clazz)
        {
            for (int i = 0; i < hbClasses.length; i++)
            {
                if (clazz.equals(hbClasses[i]))
                    return jdkClasses[i];
            }
            return clazz;
        }
    }