/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.dam.tmcdb.service;

import java.util.List;

import alma.acs.tmcdb.Schemas;
import alma.obops.dam.ServiceException;

public class SchemasServiceImpl extends TmcdbAbstractService implements SchemasService 
{
	@SuppressWarnings("unchecked")
	@Override
	public List<Schemas> findAll() throws ServiceException {
		List<Schemas> schemas = (List<Schemas>)getDao().findAll(getDomainClass());
		return schemas;
	}

	@Override
	public Class<?> getDomainClass() {
		return Schemas.class;
	}
}
