/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.dam.tmcdb.service;

import java.util.List;

import org.hibernate.Session;

import alma.obops.dam.ServiceException;
import alma.tmcdb.domain.PointingModel;
import alma.tmcdb.history.HistoryRecord;
import alma.tmcdb.history.PointingModelHistorian;

/**
 * Business layer for PointingModel
 *
 * @author sharring, Oct 26, 2009
 * 
 */
public class PointingModelServiceImpl extends TmcdbAbstractService implements PointingModelService 
{
    /**
     * Public constructor
     */
    public PointingModelServiceImpl() {
        super();
    }
    
	@Override
	@SuppressWarnings("unchecked")
	public List<PointingModel> findAll() throws ServiceException {
		return (List<PointingModel>) getDao().findAll(getDomainClass());
	}

	@Override
	public Class<?> getDomainClass() {
		return PointingModel.class;
	}
	
	@Override 
	public void update(Object obj)
	{
		super.update(obj);
		this.getDao().flush();
	}
	
	@Override
	public void hydrate(Object domainObject) throws ServiceException {
		PointingModel pointingModel = (PointingModel) domainObject;
		this.getDao().reAttach(domainObject);
		pointingModel.getTerms().size();
	}
	
	@Override public void hydrateToTerms(Object domainObject) throws ServiceException {
		hydrate(domainObject);
		PointingModel pointingModel = (PointingModel) domainObject;
		pointingModel.getTerms().keySet().size();
		pointingModel.getTerms().values().size();
	}
	
	@Override public Session getSession() {
		return this.getDao().getHibernateSession();
	}
	
	@Override public List<HistoryRecord> getHistory(PointingModel pm) 
	{
		List<HistoryRecord> retVal = null;
		
		PointingModelHistorian historian = new PointingModelHistorian(this.getDao().getHibernateSession());
		retVal = historian.getHistory(pm);
		
		return retVal;
	}

	@Override
	public PointingModel getHistoricalPointingModel(PointingModel pm,
			Long version) 
	{
		PointingModel retVal = null;
		
		PointingModelHistorian historian = new PointingModelHistorian(this.getDao().getHibernateSession());
		retVal = historian.recreate(version, pm);
		
		return retVal;
	}

	@Override
	public boolean prepareSave(PointingModel pm, String who, String description) 
	{
		boolean retVal = false;
		PointingModelHistorian historian = new PointingModelHistorian(this.getDao().getHibernateSession());
		retVal = historian.prepareSave(pm, who, description);
		return retVal;
	}

	@Override
	public void endSave(PointingModel pm) 
	{
		PointingModelHistorian historian = new PointingModelHistorian(this.getDao().getHibernateSession());
		historian.endSave(pm.getAntenna());
	}
}
