/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * PadServiceImpl.java
 *
 * Copyright European Southern Observatory 2008
 */

package alma.obops.dam.tmcdb.service;

import java.io.Serializable;
import java.util.List;


import alma.obops.dam.ServiceException;
import alma.tmcdb.domain.Pad;
import alma.tmcdb.history.HistoryRecord;
import alma.tmcdb.history.PadHistorian;

/**
 * Business layer for Pad
 *
 * @author amchavan, Sep 10, 2008
 * 
 */



public class PadServiceImpl extends TmcdbAbstractService implements PadService 
{

    /**
     * Public constructor
     */
    public PadServiceImpl( ) {
        super( );
    }
    
    /** @see alma.obops.dam.AbstractService#create(java.lang.Object) */
    @Override
    public Serializable create( Object domainObject ) throws ServiceException {
        if( domainObject instanceof Pad ) {
            return create( (Pad) domainObject );
        }
        throw new IllegalArgumentException( "Input arg is not a Pad" );
    }
    
    /**
     * Add to the database the input Pad
     * @return The generated Pad ID (an instance of {@link java.lang.Long})
     * @throws ServiceException 
     */
    public Serializable create( Pad pad ) throws ServiceException {
        getDao().update( pad.getConfiguration() );
     
        return pad.getId();
    }

    @Override
    public void delete( Object domainObject ) throws ServiceException {
        // TODO 
        throw new RuntimeException( "Not yet implemented" );
    }

    @Override
    public void update( Object domainObject ) throws ServiceException {
        getDao().update(domainObject);
    }

    /**
     * @see alma.obops.dam.Service#getDomainClass()
     */
    @Override
    public Class<?> getDomainClass() {
        return Pad.class;
    }
    
   /* (non-Javadoc)
    * @see alma.obops.dam.AbstractService#hydrate(java.lang.Object)
    */
   @Override
   public void hydrate(Object domainObject) throws ServiceException {
      Pad pad = (Pad) domainObject;
      this.getDao().reAttach(pad);
      if(pad.getScheduledAntennas() != null) {
         pad.getScheduledAntennas().size();
      }
   }      

   /**
    * @see alma.obops.dam.service.IConfigurationService#findAll()
    */
   @SuppressWarnings("unchecked")
   public List<Pad> findAll() throws ServiceException {
	   List<Pad> pads = (List<Pad>)getDao().findAll(getDomainClass());
      return pads;
   }

   @Override
   public Pad getHistoricalPad(Pad pad, Long version) 
   {
	   Pad retVal = null;

	   PadHistorian historian = new PadHistorian(this.getDao().getHibernateSession());
	   retVal = historian.recreate(version, pad);

	   return retVal;
   }
   
   @Override
	public void endSave(Pad pad) 
	{
	   PadHistorian historian = new PadHistorian(this.getDao().getHibernateSession());
	   historian.endSave(pad);
	}

	@Override
	public boolean prepareSave(Pad pad, String who, String description) 
	{	
		boolean retVal = false;
		PadHistorian historian = new PadHistorian(this.getDao().getHibernateSession());
		retVal = historian.prepareSave(pad, who, description);
		return retVal;
	}

	@Override
	public List<HistoryRecord> getHistory(Pad pad) 
	{
		List<HistoryRecord> retVal = null;

		PadHistorian historian = new PadHistorian(this.getDao().getHibernateSession());
		retVal = historian.getHistory(pad);

		return retVal;
	}
}
