/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * PadService.java
 *
 * Copyright European Southern Observatory 2008
 */

package alma.obops.dam.tmcdb.service;

import java.io.Serializable;
import java.util.List;

import alma.obops.dam.Service;
import alma.obops.dam.ServiceException;
import alma.tmcdb.domain.Pad;
import alma.tmcdb.history.HistoryRecord;

/**
 * Business layer for Pad
 *
 * @author amchavan, Sep 10, 2008
 * 
 */



public interface PadService extends Service {


    /** @see alma.obops.dam.AbstractService#create(java.lang.Object) */
    @Override
    public Serializable create( Object domainObject ) throws ServiceException;
    
    /**
     * Add to the database the input Pad
     * @return The generated Pad ID (an instance of {@link java.lang.Long})
     * @throws ServiceException 
     */
    public Serializable create( Pad pad ) throws ServiceException;

    @Override
    public void delete( Object domainObject ) throws ServiceException;

    @Override
    public void update( Object domainObject ) throws ServiceException;

    /**
     * @see alma.obops.dam.Service#getDomainClass()
     */
    @Override
    public Class<?> getDomainClass();
    
   /**
    * @return all the pads.
    * @throws ServiceException
    */
   public List<Pad> findAll() throws ServiceException;
   
   public boolean prepareSave(Pad ent, String who, String description);
   public void endSave(Pad ent);

   /**
    * Gets a "historical" pad, that is a (version of a) pad as it existed at some point in the past.
    * @return the historical pad.
    */
   public Pad getHistoricalPad(Pad pad, Long versionNumber);
   
   /**
    * Gets a list of history records, depicting all of the versions of a pad.
    * @param pad the pad for which we want the history records (versions).
    * @return a list of history records depicting all of the versions of the designated pad.
    */
   public List<HistoryRecord> getHistory(Pad pad);
}
