/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * LruTypeService.java
 *
 * Copyright European Southern Observatory 2008
 */

package alma.obops.dam.tmcdb.service;

import java.util.List;

import alma.obops.dam.Service;
import alma.obops.dam.ServiceException;
import alma.tmcdb.domain.AssemblyRole;
import alma.tmcdb.domain.AssemblyType;
import alma.tmcdb.domain.BaseElementStartupType;
import alma.tmcdb.domain.LruType;

/**
 * Business layer for LruType
 * 
 * @author rkurowsk, Dec 12, 2008
 * 
 */



public interface LruTypeService extends Service {

	/**
	 * Read an instance from the database; this is a thin wrapper around
	 * {@link LruTypeDao#read(String)}.
	 * 
	 * @return The LruType whose name is given as input
	 * @throws ServiceException
	 */
	public LruType read(String lruName) throws ServiceException;

    /**
     * Find LruTypes for a given baseElementStartupType
     *  
     * @param baseElementType
     * @return
     * @throws ServiceException
     */
    public LruType[] findByBaseElementStartupType( BaseElementStartupType baseElementType ) throws ServiceException;        
    
    /**
     * Find all the AsemblyTypes
     * @return
     * @throws ServiceException
     */
    public AssemblyType[] findAllAssemblyTypes() throws ServiceException;
        
    /**
     * Find all the AssemblyRoles
     * @return
     * @throws ServiceException
     */
    public AssemblyRole[] findAllAssemblyRoles() throws ServiceException;

    /**
     * Hydrates an LruType to its assembly types.
     * @param domainObject
     */
	public void hydrateToAssemblyTypes(Object domainObject);
	
	/**
     * @return all the lrutypes
     * @throws ServiceException
     */
    public List<LruType> findAll() throws ServiceException;
}
