/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.dam.tmcdb.service;

import java.util.List;

import alma.acs.tmcdb.Location;
import alma.obops.dam.ServiceException;

public class LocationServiceImpl extends TmcdbAbstractService implements LocationService 
{
	@SuppressWarnings("unchecked")
	@Override
	public List<Location> findAll() 
	{
		return (List<Location>)(this.getDao().findAll(this.getDomainClass()));
	}

	@Override
	public List<?> findByName(String substring) throws ServiceException {
		return this.getDao().findByParameter("mnemonic", substring, getDomainClass());
	}
	
	@Override
	public Class<?> getDomainClass() 
	{
		return Location.class;
	}
}