/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.dam.tmcdb.service;

import java.util.ArrayList;
import java.util.List;

import org.hibernate.criterion.Restrictions;

import alma.obops.dam.ServiceException;
import alma.tmcdb.domain.AssemblyType;
import alma.tmcdb.domain.HwSchema;

@SuppressWarnings("unchecked")
public class HwSchemaServiceImpl extends TmcdbAbstractService implements HwSchemaService
{
	/**
     * Public constructor
     */
    public HwSchemaServiceImpl(){
    	super();
    }

    public List<HwSchema> findAll() throws ServiceException {
 	   List<HwSchema> assemblies = (List<HwSchema>)getDao().findAll(getDomainClass());
       return assemblies;
    }

    @Override
    public List<HwSchema> findForAssemblyType(AssemblyType at) throws ServiceException {
    	List<Object> rest = new ArrayList<Object>();
    	rest.add( Restrictions.eq("assemblyType", at));
    	return (List<HwSchema>)getDao().find(rest, null, getDomainClass());
    }

	@Override
	public Class<?> getDomainClass() {
		return HwSchema.class;
	}

	@Override
	public void hydrate(Object domainObject) throws ServiceException {
		HwSchema assembly = (HwSchema) domainObject;
		getDao().reAttach(assembly);
		assembly.getUrn();
	}
}
