/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.dam.tmcdb.service;

import java.io.Serializable;
import java.util.List;

import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;

import alma.obops.dam.ServiceException;
import alma.tmcdb.domain.HolographyTower;
import alma.tmcdb.domain.HolographyTowerToPad;
import alma.tmcdb.domain.Pad;

public class HolographyTowerToPadServiceImpl extends TmcdbAbstractService implements HolographyTowerToPadService 
{
	/**
	 * Public constructor
	 */
	public HolographyTowerToPadServiceImpl( ) 
	{
		super( );
	}

	/* (non-Javadoc)
	 * @see alma.obops.dam.AbstractService#create(java.lang.Object)
	 */
	@Override
	public Serializable create( Object domainObject ) throws ServiceException 
	{
		if(!(domainObject instanceof HolographyTowerToPad))
		{
			throw new IllegalArgumentException( "Input arg is not a HolographyTowerToPad" );
		}
		return create((HolographyTowerToPad)domainObject);
	}

	/* (non-Javadoc)
	 * @see alma.obops.dam.Service#getDomainClass()
	 */
	@Override
	public Class<?> getDomainClass() {
		return HolographyTowerToPad.class;
	}

	@SuppressWarnings("unchecked")
	public List<HolographyTowerToPad> findCurrentHolographyTowerToPadAssignmentForPad(Pad pad) throws ServiceException
	{
		// create the criteria
		DetachedCriteria criteria = DetachedCriteria.forClass(HolographyTowerToPad.class);
		criteria.add( Restrictions.eq("pad.id", pad.getId()));

		// perform the query
		List<HolographyTowerToPad> results = (List<HolographyTowerToPad>) this.getDao().find(criteria);	
		for(HolographyTowerToPad h2p : results) {
			h2p.getPad().getName();
			h2p.getHolographyTower().getName();
			h2p.getPad().getConfiguration();
		}
		return results;
	}

	/**
	 * @see alma.obops.dam.service.IConfigurationService#findAll()
	 */
	@SuppressWarnings("unchecked")
	public List<HolographyTowerToPad> findAll() throws ServiceException 
	{
		List<HolographyTowerToPad> holographyTowerToPads = (List<HolographyTowerToPad>)getDao().findAll(getDomainClass());
		return holographyTowerToPads;
	}

	@Override
	public Serializable create(HolographyTowerToPad h2p)
			throws ServiceException 
	{
		return getDao().create( h2p );
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<HolographyTowerToPad> findCurrentHolographyTowerToPadAssignmentForHolographyTower(HolographyTower holoTower) throws ServiceException 
	{
		// create the criteria
 		DetachedCriteria criteria = DetachedCriteria.forClass(HolographyTowerToPad.class);
		criteria.add( Restrictions.eq("holographyTower.id", holoTower.getId()));
  
 		// perform the query
 		List<HolographyTowerToPad> results = (List<HolographyTowerToPad>) this.getDao().find(criteria);	
 		for(HolographyTowerToPad h2p : results) {
 			h2p.getPad().getName();
 			h2p.getHolographyTower().getName();
 			h2p.getPad().getConfiguration().hashCode();
 			h2p.getPad().getConfiguration().getBaseElements();
 		}
 		return results;
	}
}
