/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.dam.tmcdb.service;

import java.util.List;

import alma.obops.dam.ServiceException;
import alma.tmcdb.domain.FocusModel;
import alma.tmcdb.history.FocusModelHistorian;
import alma.tmcdb.history.HistoryRecord;

/**
 * Implementation of service for focus models.
 * @author sharring
 */
public class FocusModelServiceImpl extends TmcdbAbstractService implements
		FocusModelService 
{
	/**
	 * Public constructor
	 */
	public FocusModelServiceImpl() {
		super();
	}

	@Override
	public void update(Object obj)
	{
		super.update(obj);
		this.getDao().flush();
	}
    
	@SuppressWarnings("unchecked")
	@Override
	public List<FocusModel> findAll() throws ServiceException {
		return (List<FocusModel>) getDao().findAll(getDomainClass());
	}

	@Override
	public Class<?> getDomainClass() {
		return FocusModel.class;
	}

	@Override public List<HistoryRecord> getHistory(FocusModel fm) 
	{
		List<HistoryRecord> retVal = null;
		
		FocusModelHistorian historian = new FocusModelHistorian(this.getDao().getHibernateSession());
		retVal = historian.getHistory(fm);
		
		return retVal;
	}

	@Override
	public FocusModel getHistoricalFocusModel(FocusModel fm, Long version) 
	{
		FocusModel retVal = null;
		
		FocusModelHistorian historian = new FocusModelHistorian(this.getDao().getHibernateSession());
		retVal = historian.recreate(version, fm);
		
		return retVal;
	}

	@Override
	public void endSave(FocusModel fm) 
	{
		FocusModelHistorian historian = new FocusModelHistorian(this.getDao().getHibernateSession());
		historian.endSave(fm.getAntenna());
	}

	@Override
	public boolean prepareSave(FocusModel fm, String who, String description) 
	{	
		boolean retVal = false;
		FocusModelHistorian historian = new FocusModelHistorian(this.getDao().getHibernateSession());
		retVal = historian.prepareSave(fm, who, description);
		return retVal;
	}
}
