/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.dam.tmcdb.service;

import java.util.List;

import alma.acs.tmcdb.Configuration;
import alma.acs.tmcdb.FaultFamily;
import alma.acs.tmcdb.FaultMember;
import alma.obops.dam.Service;
import alma.obops.dam.ServiceException;

/**
 * Interface for the fault member service.
 * @author sharring
 */
public interface FaultMemberService extends Service 
{
	/**
     * @return all the fault members
     * @throws ServiceException
     */
    public List<FaultMember> findAll() throws ServiceException;
    
    public List<FaultMember> findByFaultFamily(FaultFamily ff) throws ServiceException;
    
    /**
     * @return all the fault members in a given configuration
     * @throws ServiceException
     */
    public List<FaultMember> findAllInConfiguration(Configuration config) throws ServiceException;
    
    public List<FaultMember> findFaultMembersByRegExInConfig(String fmregex, String ffregex, Configuration config);
    
    public FaultMember hydrateAndMerge(FaultMember member);
}
