/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.dam.tmcdb.service;

import java.util.List;

import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;

import alma.acs.tmcdb.Configuration;
import alma.acs.tmcdb.DefaultMember;
import alma.obops.dam.ServiceException;

public class DefaultMemberServiceImpl extends TmcdbAbstractService implements DefaultMemberService 
{

	@Override
	public Class<?> getDomainClass() {
		return DefaultMember.class;
	}

	@Override 
	public void hydrate(Object domainObject)
	{
		if(domainObject instanceof DefaultMember) {
			DefaultMember defaultMember = (DefaultMember) domainObject;
			doHydration(defaultMember);
		}
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<DefaultMember> findAllInConfig(Configuration config) throws ServiceException 
	{
		DetachedCriteria searchCriteria = DetachedCriteria.forClass(DefaultMember.class).
		createAlias("configuration", "config").
		add(Restrictions.eq("config.configurationId", config.getConfigurationId()));

		List<DefaultMember> defaultMembers = (List<DefaultMember>)this.getDao().find(searchCriteria);
		return defaultMembers;
	}

	@Override
	public DefaultMember hydrateAndMerge(DefaultMember defaultMember) 
	{
		defaultMember = (DefaultMember) this.getDao().merge(defaultMember);
		doHydration(defaultMember);
		return defaultMember;
	}

	private void doHydration(DefaultMember defaultMember) {
		this.getDao().reAttach(defaultMember);
		defaultMember.getFaultFamily();
		if(null != defaultMember.getLocation())
		{
			defaultMember.getLocation().getMnemonic();
		}
	}
}
