/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.dam.tmcdb.service;

import java.util.List;

import alma.acs.tmcdb.Configuration;
import alma.acs.tmcdb.DefaultMember;
import alma.obops.dam.Service;
import alma.obops.dam.ServiceException;

public interface DefaultMemberService extends Service 
{
	/**
	 * @param config the Configuration for which we wish to get all of the fault families.
     * @return all the default members for the given configuration.
     * @throws ServiceException
     */
    public List<DefaultMember> findAllInConfig(Configuration config) throws ServiceException;
    
    public DefaultMember hydrateAndMerge(DefaultMember member);
}
