/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * ComputerServiceImpl.java
 */
package alma.obops.dam.tmcdb.service;

import java.util.ArrayList;
import java.util.List;

import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.Subqueries;

import alma.acs.tmcdb.Component;
import alma.acs.tmcdb.Configuration;
import alma.acs.tmcdb.DefaultCanAddress;

/**
 * Business layer implementation for Computer objects
 * @author rtobar, Jul 20, 2010
 */

public class DefaultCanAddressServiceImpl extends TmcdbAbstractService implements DefaultCanAddressService {

	@SuppressWarnings("unchecked")
	@Override
	public List<DefaultCanAddress> findAll() {
		return (List<DefaultCanAddress>)getDao().findAll(getDomainClass());
	}

	@Override
	public Class<?> getDomainClass() {
		return DefaultCanAddress.class;
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<DefaultCanAddress> findAll(Configuration config) {

		List<Object> criteria = new ArrayList<Object>();

		DetachedCriteria detachedCriteria = DetachedCriteria.forClass(Component.class);
  		detachedCriteria.add( Restrictions.eq("configuration", config) );
  		detachedCriteria.setProjection(Property.forName("componentId"));
  		criteria.add( Subqueries.propertyIn("componentId", detachedCriteria) );

  		return (List<DefaultCanAddress>)getDao().find(criteria, null, getDomainClass());
	}

	@Override
	public DefaultCanAddress findForComponent(Component component) {

		List<Object> criteria = new ArrayList<Object>();
		criteria.add( Restrictions.eq("componentId", component.getComponentId()) );

		List<?> result = getDao().find(criteria, null, getDomainClass());
		if( result.size() == 0 )
			return null;
		return (DefaultCanAddress)result.iterator().next();

	}
}
