/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * ContainerServiceImpl.java
 */
package alma.obops.dam.tmcdb.service;

import java.util.ArrayList;
import java.util.List;

import org.hibernate.criterion.Restrictions;

import alma.acs.tmcdb.Component;
import alma.acs.tmcdb.Container;
import alma.acs.tmcdb.ContainerStartupOption;
import alma.obops.dam.ServiceException;

/**
 * Business layer implementation for Software Configuration objects
 * 
 * @author rtobar, Feb 22, 2010
 *
 */

public class ContainerServiceImpl extends TmcdbAbstractService implements ContainerService {

	/* (non-Javadoc)
	 * @see alma.obops.dam.Service#getDomainClass()
	 */
	@Override
	public Class<?> getDomainClass() {
		return Container.class;
	}

	@Override
	public void hydrateConfiguration(Container cont) {
		this.getDao().reAttach(cont);
		cont.getConfiguration().getConfigurationName();
	}

	/* (non-Javadoc)
	 * @see alma.obops.dam.tmcdb.service.ContainerService#hydrateComponents(alma.acs.tmcdb.Container)
	 */
	@Override
	public void hydrateComponents(Container cont) {
		this.getDao().reAttach(cont);
		for(Component comp: cont.getComponents()) {
			comp.getComponentName();
			comp.getConfiguration().getConfigurationName();
		}
	}
	
	/* (non-Javadoc)
	 * @see alma.obops.dam.tmcdb.service.ContainerService#hydrateComponents(alma.acs.tmcdb.Container)
	 */
	@Override
	public void hydrateContainerStartupOptions(Container cont) {
		this.getDao().reAttach(cont);
		for(ContainerStartupOption comp: cont.getContainerStartupOptions()) {
			comp.getOptionName();
			comp.getContainer().getConfiguration().getConfigurationName();
		}
	}

	/* (non-Javadoc)
	 * @see alma.obops.dam.tmcdb.service.ContainerService#hydrateLoggingConfig(alma.acs.tmcdb.Container)
	 */
	@Override
	public void hydrateLoggingConfig(Container cont) {
		this.getDao().reAttach(cont);
		cont.getLoggingConfig().getFlushPeriodSeconds();
	}

	/* (non-Javadoc)
	 * @see alma.obops.dam.tmcdb.service.ContainerService#findContainer(alma.acs.tmcdb.Container)
	 */
	@Override
	public Container findContainer(Container cont) {
		List<Object> criteria = new ArrayList<Object>();
		criteria.add( Restrictions.eq("containerName", cont.getContainerName()) );
		criteria.add( Restrictions.eq("path", cont.getPath()) );
		criteria.add( Restrictions.eq("configuration", cont.getConfiguration()));
		List<?> r = this.getDao().find(criteria, null, this.getDomainClass());
		if( r.size() == 0 )
			return null;
		return (Container)r.iterator().next();
	}

	/**
     * @see alma.obops.dam.service.IConfigurationService#findAll()
     */
    @SuppressWarnings("unchecked")
    public List<Container> findAll() throws ServiceException {
 	   List<Container> assemblystartups = (List<Container>)getDao().findAll(getDomainClass());
       return assemblystartups;
    }
}
