/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * ComputerServiceImpl.java
 */
package alma.obops.dam.tmcdb.service;

import java.util.ArrayList;
import java.util.List;

import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;

import alma.acs.tmcdb.AcsService;
import alma.acs.tmcdb.Computer;
import alma.acs.tmcdb.Configuration;
import alma.acs.tmcdb.Container;

/**
 * Business layer implementation for Computer objects
 * @author rtobar, Feb 22, 2010
 */
public class ComputerServiceImpl extends TmcdbAbstractService implements ComputerService {

	/* (non-Javadoc)
	 * @see alma.obops.dam.Service#getDomainClass()
	 */
	@Override
	public Class<?> getDomainClass() {
		return Computer.class;
	}

	public void hydrateConfiguration(Computer comp) {
		this.getDao().reAttach(comp);
		comp.getConfiguration().getConfigurationName();
	}

	/* (non-Javadoc)
	 * @see alma.obops.dam.tmcdb.service.ComputerService#hydrateContainers(alma.acs.tmcdb.Computer)
	 */
	@Override
	public void hydrateContainers(Computer computer) {
		this.getDao().reAttach(computer);
		for(Container cont: computer.getContainers()) {
			cont.getContainerName();
			cont.getConfiguration().getConfigurationName();
		}
	}

	@Override
	public Computer findComputer(Computer comp) {

		List<Object> criteria = new ArrayList<Object>();
		criteria.add( Restrictions.eq("networkName", comp.getNetworkName()) );
		criteria.add( Restrictions.eq("configuration", comp.getConfiguration()));
		List<?> r = this.getDao().find(criteria, null, this.getDomainClass());
		if( r.size() == 0 )
			return null;
		return (Computer)r.iterator().next();
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<Computer> findByNameWithinConfiguration(Configuration config,
			String name) 
	{
		DetachedCriteria searchCriteria = DetachedCriteria.forClass(Computer.class).
		add(Restrictions.eq("name", name)).
		createAlias("configuration", "configAlias").
		add(Restrictions.eq("configAlias.configurationId", config.getConfigurationId()));
		
		List<Computer> retVal = (List<Computer>)this.getDao().find(searchCriteria);
		return retVal;
	}
	
	@Override
	public void hydrate(Object obj) {
		Computer comp = (Computer) obj;
		this.getDao().reAttach(comp);
		comp.getNetworkName();
	}

	@Override
	public void hydrateAcsServices(Computer computer)
	{
		this.getDao().reAttach(computer);
		for(AcsService service: computer.getAcsServices()) {
			service.getServiceInstanceName();
			service.getConfiguration().getConfigurationName();
		}
	}
}
