/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * ComponentTypeService.java
 *
 * Copyright European Southern Observatory 2008
 */

package alma.obops.dam.tmcdb.service;

import java.util.List;


import alma.acs.tmcdb.ComponentType;
import alma.obops.dam.ServiceException;


/**
 * Business layer for ComponentType
 *
 * @author amchavan, Sep 10, 2008
 * 
 */



public class ComponentTypeServiceImpl 
    extends TmcdbAbstractService implements ComponentTypeService {

    /**
     * Public constructor
     * @param antennaDao The DaoFactory we use for our business
     */
    public ComponentTypeServiceImpl() {
        super( );
    }

	/**
     * @see alma.obops.dam.Service#getDomainClass()
     */
    @Override
    public Class<?> getDomainClass() {
        return ComponentType.class;
    }

    @SuppressWarnings("unchecked")
	@Override
    public void hydrateAll() {
    	List<ComponentType> allComponentTypes = (List<ComponentType>) getDao().findAll(getDomainClass());
    	for(ComponentType compType : allComponentTypes) {
    		hydrate(compType);
    	}
    }
    
    @Override
    public void hydrate(Object domainObject) {
    	this.getDao().reAttach(domainObject);
    }

	@Override
	public List<?> findByNameExactMatch(String substring) throws ServiceException {
		return this.getDao().findByParameterExactMatch("IDL", substring, getDomainClass());
	}
	
	@Override
	public List<?> findByName(String substring) throws ServiceException {
		return this.getDao().findByParameter("IDL", substring, getDomainClass());
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<ComponentType> findAll() {
		return (List<ComponentType>)(this.getDao().findAll(this.getDomainClass()));
	}
}
