/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.dam.tmcdb.service;

import java.io.Serializable;
import java.util.List;

import alma.obops.dam.ServiceException;
import alma.tmcdb.domain.BaseElementStartup;

public class BaseElementStartupServiceImpl extends TmcdbAbstractService 
   implements BaseElementStartupService {
    /**
     * Public constructor
     */
    public BaseElementStartupServiceImpl( ) {
        super();
    }
    
	@Override
	public void hydrateToBaseElementChildren(Object domainObject)
			throws ServiceException 
	{
		hydrate(domainObject);
		BaseElementStartup startup = (BaseElementStartup) domainObject;
		this.getDao().reAttach(startup);
		startup.getAssemblyStartups().size();
		for(BaseElementStartup childStartup : startup.getChildren()) {
			childStartup.getAssemblyStartups().size();
			childStartup.getChildren().size();
		}
	}
	
	/* (non-Javadoc)
     * @see alma.obops.dam.AbstractService#create(java.lang.Object)
     */
    @Override
    public Serializable create( Object domainObject ) throws ServiceException {
        if( domainObject instanceof BaseElementStartup ) {
            return getDao().create( domainObject );
        }
        throw new IllegalArgumentException( "Input arg is not an BaseElementStartup" );
    }

    /* (non-Javadoc)
     * @see alma.obops.dam.Service#getDomainClass()
     */
    @Override
    public Class<?> getDomainClass() {
        return BaseElementStartup.class;
    }

    /* (non-Javadoc)
     * @see alma.obops.dam.AbstractService#hydrate(java.lang.Object)
     */
     @Override
     public void hydrate(Object domainObject) throws ServiceException {
    	BaseElementStartup baseElementStartup = (BaseElementStartup) domainObject;
    	if(null != baseElementStartup.getBaseElement()) {
           this.getDao().reAttach(baseElementStartup);
    	} else {
    		this.getDao().reAttach(baseElementStartup.getParent());
    		BaseElementStartup rootOfTree = baseElementStartup.getParent();
    		while(null != rootOfTree && null == rootOfTree.getBaseElement()) {
    			rootOfTree = rootOfTree.getParent();
    			this.getDao().reAttach(rootOfTree);
    		}
    		if(null != rootOfTree && null != rootOfTree.getBaseElement()) {
    			this.getDao().reAttach(rootOfTree);
    		}
    	}
    	baseElementStartup.getAssemblyStartups().size();
     }	
     
     /**
      * @see alma.obops.dam.service.IConfigurationService#findAll()
      */
     @SuppressWarnings("unchecked")
     public List<BaseElementStartup> findAll() throws ServiceException {
  	   List<BaseElementStartup> baseElementStartups = (List<BaseElementStartup>)getDao().findAll(getDomainClass());
        return baseElementStartups;
     }
     
}
