/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
package alma.obops.dam.tmcdb.service;

import java.util.ArrayList;
import java.util.List;

import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

import alma.tmcdb.domain.BaseElement;
import alma.tmcdb.domain.BaseElementType;
import alma.tmcdb.domain.HwConfiguration;

public class BaseElementServiceImpl extends TmcdbAbstractService implements BaseElementService 
{
	@Override
	public Class<?> getDomainClass() {
		return BaseElement.class;
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<BaseElement> findTopLevelBaseElementsByConfiguration(HwConfiguration configuration) 
	{		
		if(configuration == null) {
			throw new IllegalArgumentException("BaseElementService.findTopLevelBaseElementsByConfiguration(): Configuration cannot be null!");
		}
		
		Criterion searchCriterionCon = Restrictions.eq("configuration", configuration);
		
		Object[] items = { BaseElementType.Antenna, BaseElementType.AOSTiming, 
				BaseElementType.CentralLO, BaseElementType.WeatherStationController };
		Criterion searchCriterionType = Restrictions.in("type", items);
		
		Criterion totalCriteria = Restrictions.and(searchCriterionCon, searchCriterionType);
		
		List<Object> searchCriteria = new ArrayList<Object>();
		searchCriteria.add(totalCriteria);
		
		List<BaseElement> results = (List<BaseElement>)this.getDao().find(searchCriteria, null, getDomainClass());
		for(BaseElement be: results) {
			be.getConfiguration().getSwConfiguration().getConfigurationName();
		}
		
		return results;
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public List<BaseElement> findBaseElementByNameInConfiguration(String name, HwConfiguration configuration) 
	{		
		if(configuration == null) {
			throw new IllegalArgumentException("BaseElementService.findBaseElementByNameInConfiguration(): Configuration cannot be null!");
		}
		
		Criterion searchCriterionCon = Restrictions.eq("configuration", configuration);
		Criterion searchCriterionName = Restrictions.eq("name", name);
		Criterion totalCriteria = Restrictions.and(searchCriterionName, searchCriterionCon);
		
		List<Object> searchCriteria = new ArrayList<Object>();
		searchCriteria.add(totalCriteria);
		
		List<BaseElement> results = (List<BaseElement>)this.getDao().find(searchCriteria, null, getDomainClass());
		
		return results;
	}
}
