/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * AssemblyTypeServiceImpl.java
 *
 * Copyright European Southern Observatory 2008
 */

package alma.obops.dam.tmcdb.service;

import java.util.List;


import alma.obops.dam.HibernateDao;
import alma.obops.dam.ServiceException;
import alma.tmcdb.domain.AssemblyType;

/**
 * Business layer for AssemblyType
 * 
 * @author rkurowsk, Dec 12, 2008
 * 
 */


public class AssemblyTypeServiceImpl extends TmcdbAbstractService 
	implements AssemblyTypeService {

	/**
	 * Public constructor
	 */
	public AssemblyTypeServiceImpl() {
		super();
	}

	/**
	 * @see alma.obops.dam.Service#getDomainClass()
	 */
	@Override
	public Class<?> getDomainClass() {
		return AssemblyType.class;
	}

	/**
	 * Read an instance from the database; this is a thin wrapper around
	 * {@link HibernateDao#read(String)}.
	 * 
	 * @return The AssemblyType whose name is given as input
	 * @throws ServiceException
	 */
	public AssemblyType read(String assemblyName) throws ServiceException {
		return (AssemblyType)getDao().read(assemblyName, AssemblyType.class);
	}

	@Override 
	public void hydrate(Object domainObject)
	{
		this.getDao().reAttach(domainObject);
		if(domainObject instanceof AssemblyType) {
			AssemblyType assemblyType = (AssemblyType) domainObject;
			assemblyType.getName();
			assemblyType.getRoles().size();
		}
	}
	
	/**
     * @see alma.obops.dam.service.IConfigurationService#findAll()
     */
    @SuppressWarnings("unchecked")
    public List<AssemblyType> findAll() throws ServiceException {
 	   List<AssemblyType> assemblyTypes = (List<AssemblyType>)getDao().findAll(getDomainClass());
       return assemblyTypes;
    }

    /* (non-Javadoc)
     * @see alma.obops.dam.tmcdb.service.AssemblyTypeService#hydrateComponentType(alma.tmcdb.domain.AssemblyType)
     */
    public void hydrateComponentType(AssemblyType at) throws ServiceException {
    	this.getDao().reAttach(at);
    	at.getComponentType().getIDL();
    }

}
