/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * AssemblyTypeService.java
 *
 * Copyright European Southern Observatory 2008
 */

package alma.obops.dam.tmcdb.service;

import java.util.List;

import alma.acs.tmcdb.ComponentType;
import alma.obops.dam.Service;
import alma.obops.dam.ServiceException;
import alma.tmcdb.domain.AssemblyType;

/**
 * Business layer for AssemblyType
 * 
 * @author rkurowsk, Dec 12, 2008
 * 
 */



public interface AssemblyTypeService extends Service {

	/**
	 * Read an instance from the database; this is a thin wrapper around
	 * {@link AssemblyTypeDao#read(String)}.
	 * 
	 * @return The AssemblyType whose name is given as input
	 * @throws ServiceException
	 */
	public AssemblyType read(String assemblyName) throws ServiceException;
	
	/**
     * @return all the assembly types
     * @throws ServiceException
     */
    public List<AssemblyType> findAll() throws ServiceException;

    /**
     * Hydrates the {@link ComponentType} object associated with the given Assembly Type
     * @param at The Assembly Type
     * @throws ServiceException
     */
    public void hydrateComponentType(AssemblyType at) throws ServiceException;
}