/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * AntennaService.java
 *
 * Copyright European Southern Observatory 2008
 */

package alma.obops.dam.tmcdb.service;

import java.io.Serializable;
import java.util.List;

import alma.obops.dam.Service;
import alma.obops.dam.ServiceException;
import alma.tmcdb.domain.Antenna;
import alma.tmcdb.domain.HwConfiguration;
import alma.tmcdb.history.HistoryRecord;


/**
 * Business layer for Antenna
 *
 * @author amchavan, Sep 10, 2008
 * 
 */


public interface AntennaService extends Service {

	/**
     * Add to the database the input Antenna
     * @return The generated Antenna ID (an instance of {@link java.lang.Long})
     * @throws ServiceException 
     */
    public Serializable create( Antenna antenna ) throws ServiceException;
 
    /**
     * @return all the antennas
     * @throws ServiceException
     */
    public List<Antenna> findAll() throws ServiceException;

    public List<Antenna> findByLoOffsetInConfiguration(Integer loOffset, HwConfiguration config);
    public List<Antenna> findByWalshSequenceInConfiguration(Integer walshSeq, HwConfiguration config);

	public boolean prepareDelaySave(Antenna ent, String who, String description);
    public void endDelaySave(Antenna ent);
    public List<HistoryRecord> getDelayModelHistory(Antenna antenna) throws ServiceException;
    public Antenna getHistoricalDelayAntenna(Antenna antenna, Long version);
    
	public boolean prepareAntennaSave(Antenna antenna, String who,
			String description);
	public void endAntennaSave(Antenna antenna);
    public List<HistoryRecord> getAntennaHistory(Antenna antenna);
	public Antenna getHistoricalAntenna(Antenna antenna, Long version);
}
