/*******************************************************************************
  * ALMA - Atacama Large Millimeter Array
  * Copyright (c) NRAO - National Radio Astronomy Observatory, 2012
  * (in the framework of the ALMA collaboration).
  * All rights reserved.
  *
  * This library is free software; you can redistribute it and/or
  * modify it under the terms of the GNU Lesser General Public
  * License as published by the Free Software Foundation; either
  * version 2.1 of the License, or (at your option) any later version.
  *
  * This library is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this library; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 
*******************************************************************************/
package alma.obops.dam.tmcdb.service;

import java.io.Serializable;
import java.util.List;

import alma.obops.dam.ServiceException;
import alma.tmcdb.domain.AcaCorrDelays;
import alma.tmcdb.history.AcaCorrDelaysHistorian;
import alma.tmcdb.history.HistoryRecord;

/**
 * @author sharring
 *
 */
public class AcaCorrDelaysServiceImpl extends TmcdbAbstractService implements AcaCorrDelaysService 
{
    @Override
    public Serializable create( Object domainObject ) throws ServiceException {
        if( domainObject instanceof AcaCorrDelays ) {
            return getDao().create( domainObject );
        }
        throw new IllegalArgumentException( "Input arg is not an AcaCorrDelays" );
    }
    
    @Override
	public Class<?> getDomainClass() {
		return AcaCorrDelays.class;
	}
    
	@Override
	public AcaCorrDelays getHistoricalAcaCorrDelays(AcaCorrDelays acaCorrDel,
			Long version) 
	{
		AcaCorrDelays retVal = null;

		AcaCorrDelaysHistorian historian = new AcaCorrDelaysHistorian(this.getDao().getHibernateSession());
		retVal = historian.recreate(version, acaCorrDel);

		return retVal;
	}

	@Override
	public List<HistoryRecord> getHistory(AcaCorrDelays acaCorrDel) 
	{
		List<HistoryRecord> retVal = null;

		AcaCorrDelaysHistorian historian = new AcaCorrDelaysHistorian(this.getDao().getHibernateSession());
		retVal = historian.getHistory(acaCorrDel);

		return retVal;
	}

	@Override
	public boolean prepareSave(AcaCorrDelays acaCorrDel, String who,
			String description) 
	{
		boolean retVal = true;
		AcaCorrDelaysHistorian historian = new AcaCorrDelaysHistorian(this.getDao().getHibernateSession());
		retVal = historian.prepareSave(acaCorrDel, who, description);
		return retVal;
	}
	
	@Override
	public void endSave(AcaCorrDelays acaCorrDel) {
		AcaCorrDelaysHistorian historian = new AcaCorrDelaysHistorian(this.getDao().getHibernateSession());
		historian.endSave(acaCorrDel);
	}
}
