/*******************************************************************************
  * ALMA - Atacama Large Millimeter Array
  * Copyright (c) NRAO - National Radio Astronomy Observatory, 2012
  * (in the framework of the ALMA collaboration).
  * All rights reserved.
  *
  * This library is free software; you can redistribute it and/or
  * modify it under the terms of the GNU Lesser General Public
  * License as published by the Free Software Foundation; either
  * version 2.1 of the License, or (at your option) any later version.
  *
  * This library is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this library; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 
*******************************************************************************/
package alma.obops.dam.tmcdb.service;

import java.util.List;

import alma.obops.dam.Service;
import alma.tmcdb.domain.AcaCorrDelays;
import alma.tmcdb.history.HistoryRecord;

/**
 * @author sharring
 *
 */
public interface AcaCorrDelaysService extends Service 
{
	/**
	 * @param acaCorrDel the AcaCorrDelays for which we want the history
	 * @return a list of historyrecord objects depicting the history of this particular AcaCorrDelays
	 */
	public List<HistoryRecord> getHistory(AcaCorrDelays acaCorrDel);

	/**
	 * @param acaCorrDel the AcaCorrDealsy for which we want to retrieve a past state
	 * @param version the version for which we wish to retrieve the past state
	 * @return an AcaCorrDelays instance representing the state in the past
	 */
	public AcaCorrDelays getHistoricalAcaCorrDelays(AcaCorrDelays acaCorrDel, Long version);

	/**
	 * @param acaCorrDel the AcaCorrDelays which we wish to save
	 * @param who the id of the user making the change
	 * @param description a description of the change
	 * @return a boolean indicating if the acaCorrDel can be saved (true) or not (false)
	 */
	public boolean prepareSave(AcaCorrDelays acaCorrDel, String who, String description);

	/**
	 * @param acaCorrDel the AcaCorrDelays which was saved
	 */
	public void endSave(AcaCorrDelays acaCorrDel);
}
