/*******************************************************************************
 * ALMA - Atacama Large Millimeter Array
 * Copyright (c) ESO - European Southern Observatory, 2011
 * (in the framework of the ALMA collaboration).
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *******************************************************************************/
/**
 * 
 */
package alma.obops.dam.tmcdb.domain;

import java.util.Set;

import alma.acs.tmcdb.DefaultCanAddress;
import alma.tmcdb.domain.HwConfiguration;

/**
 * Domain class used when exporting/importing an entire TMCDB Configuration.
 * The HW table model adds several links back to the SW tables model,
 * being the most important the HwConfiguration -> Configuration relation.
 * Since HwConfiguration is the root of all the HW tables, all the HW elements of
 * a configuration can be reached through it. This is not the case for the DefaultCanAddress
 * table, which declares a relation DefaultCanAddress -> Component, but with no relation
 * at all with the HwConfiguration table. Then, it must be calculated and handled independently
 * from the HwConfiguration.
 * 
 * This class groups both entities (a HwConfiguration and a set of DefaultCanAddress objects)
 * to be exported/imported to/from an XML file, and also considered when cloning a configuration
 * 
 * @author rtobar, July 20th, 2010
 *
 */
public class TMCDBExport {

	private HwConfiguration hwConfiguration;
	private Set<DefaultCanAddress> defaultCanAddresses;

	public TMCDBExport(HwConfiguration hwconfig, Set<DefaultCanAddress> defaultCanAddresses) {
		this.hwConfiguration = hwconfig;
		this.defaultCanAddresses = defaultCanAddresses;
	}

	//*********************//
	// Getters and setters //
	//*********************//
	public void set_hwconfig(HwConfiguration hwConfiguration) {
		this.hwConfiguration = hwConfiguration;
	}

	public HwConfiguration get_hwconfig() {
		return hwConfiguration;
	}

	public void set_defaultCanAddresses(Set<DefaultCanAddress> defaultCanAddresses) {
		this.defaultCanAddresses = defaultCanAddresses;
	}

	public Set<DefaultCanAddress> get_defaultCanAddresses() {
		return defaultCanAddresses;
	}

}